/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.interfaces.ITree;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class TreeUtil {
    public final <E extends ITree<E>> List<E> buildTreeList(List<E> list) {
        return this.buildTreeList(list, 0L);
    }

    private <E extends ITree<E>> List<E> buildTreeList(@NotNull List<E> list, Long parentId) {
        return list.stream().filter(item -> parentId.equals(item.getParentId())).peek(item -> {
            List children = this.buildTreeList(list, item.getId());
            item.setChildren(children);
        }).toList();
    }
}

