/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.config.AirConfig;
import cn.hamm.airpower.enums.Result;
import cn.hamm.airpower.exception.ResultException;
import cn.hamm.airpower.util.AirUtil;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class SecurityUtil {
    private final String ACCESS_TOKEN_PREFIX = "access_token_";

    public final long getUserIdFromAccessToken(String accessToken) {
        Object data = AirUtil.getRedisUtil().get("access_token_" + accessToken);
        if (Objects.nonNull(data)) {
            return Long.parseLong(data.toString());
        }
        throw new ResultException(Result.UNAUTHORIZED);
    }

    public final String createAccessToken(Long userId) {
        String accessToken = AirUtil.getRandomUtil().randomString();
        try {
            this.getUserIdFromAccessToken(accessToken);
            return this.createAccessToken(userId);
        }
        catch (Exception ignored) {
            AirUtil.getRedisUtil().set("access_token_" + accessToken, userId, AirConfig.getGlobalConfig().getAuthorizeExpireTime());
            return accessToken;
        }
    }
}

