/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.enums.Result;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RequestUtil {
    private static final Logger log = LoggerFactory.getLogger(RequestUtil.class);
    private static final int MAX_IP_ADDRESS_CHAR_LENGTH = 15;

    public final boolean isUploadRequest(@NotNull HttpServletRequest request) {
        return this.isUploadFileContentType(request.getContentType());
    }

    public final boolean isUploadRequest(@NotNull ServletRequest request) {
        return this.isUploadFileContentType(request.getContentType());
    }

    public final String getIpAddress(HttpServletRequest request) {
        try {
            String ipAddress = request.getHeader("x-forwarded-for");
            if (this.isValidAddress(ipAddress)) {
                return ipAddress;
            }
            ipAddress = request.getHeader("Proxy-Client-IP");
            if (this.isValidAddress(ipAddress)) {
                return ipAddress;
            }
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
            if (this.isValidAddress(ipAddress)) {
                return ipAddress;
            }
            ipAddress = request.getRemoteAddr();
            if ("127.0.0.1".equals(ipAddress)) {
                try {
                    InetAddress inet = InetAddress.getLocalHost();
                    ipAddress = inet.getHostAddress();
                    if (this.isValidAddress(ipAddress)) {
                        return ipAddress;
                    }
                }
                catch (UnknownHostException exception) {
                    log.error("\u83b7\u53d6ID\u5730\u5740\u5f02\u5e38", (Throwable)exception);
                    Result.FORBIDDEN.show("\u83b7\u53d6ID\u5730\u5740\u5f02\u5e38");
                }
            }
            return "127.0.0.1";
        }
        catch (Exception exception) {
            log.error("\u83b7\u53d6ID\u5730\u5740\u5f02\u5e38", (Throwable)exception);
            Result.FORBIDDEN.show("\u83b7\u53d6ID\u5730\u5740\u5f02\u5e38");
            return "";
        }
    }

    @Contract(value="null -> false", pure=true)
    private boolean isUploadFileContentType(String contentType) {
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    private boolean isValidAddress(String ipAddress) {
        return Objects.nonNull(ipAddress) && !ipAddress.isEmpty() && !"127.0.0.1".equalsIgnoreCase(ipAddress);
    }

    private String getRealIpAddress(String ipAddress) {
        if (Objects.nonNull(ipAddress) && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }
}

