/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.annotation.Description;
import cn.hamm.airpower.annotation.Document;
import cn.hamm.airpower.root.RootController;
import cn.hamm.airpower.root.RootEntity;
import cn.hamm.airpower.root.RootModel;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReflectUtil {
    private static final Logger log = LoggerFactory.getLogger(ReflectUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object getFieldValue(Object object, @NotNull Field field) {
        try {
            field.setAccessible(true);
            Object object2 = field.get(object);
            return object2;
        }
        catch (IllegalAccessException exception) {
            log.error("\u53cd\u5c04\u64cd\u4f5c\u5c5e\u6027\u5931\u8d25", (Throwable)exception);
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            field.setAccessible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFieldValue(Object object, @NotNull Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException exception) {
            log.error("\u53cd\u5c04\u64cd\u4f5c\u5c5e\u6027\u5931\u8d25", (Throwable)exception);
        }
        finally {
            field.setAccessible(false);
        }
    }

    public final void clearFieldValue(Object object, Field field) {
        this.setFieldValue(object, field, null);
    }

    public final boolean isTheRootClass(@NotNull Class<?> clazz) {
        return clazz.getName().equals(RootController.class.getName()) || clazz.getName().equals(RootEntity.class.getName()) || clazz.getName().equals(Object.class.getName());
    }

    @Nullable
    public final <A extends Annotation> A getAnnotation(Class<A> annotationClass, Method method) {
        return this.getAnnotation(annotationClass, method, method.getDeclaringClass());
    }

    @Nullable
    public final <A extends Annotation> A getAnnotation(Class<A> annotationClass, @NotNull Class<?> clazz) {
        A annotation = clazz.getAnnotation(annotationClass);
        if (Objects.nonNull(annotation)) {
            return annotation;
        }
        if (this.isTheRootClass(clazz)) {
            return null;
        }
        Class<?> superClass = clazz.getSuperclass();
        return this.getAnnotation(annotationClass, superClass);
    }

    @Contract(pure=true)
    @Nullable
    public final <A extends Annotation> A getAnnotation(Class<A> annotationClass, @NotNull Field field) {
        return field.getAnnotation(annotationClass);
    }

    public final String getDescription(Class<?> clazz) {
        Description description = this.getAnnotation(Description.class, clazz);
        return Objects.isNull(description) ? clazz.getSimpleName() : description.value();
    }

    public final String getDescription(Method method) {
        Description description = this.getAnnotation(Description.class, method, method.getDeclaringClass());
        return Objects.isNull(description) ? method.getName() : description.value();
    }

    public final String getDescription(Field field) {
        Description description = this.getAnnotation(Description.class, field);
        return Objects.isNull(description) ? field.getName() : description.value();
    }

    public final String getDocument(Class<?> clazz) {
        Document document = this.getAnnotation(Document.class, clazz);
        return Objects.isNull(document) ? "" : document.value();
    }

    public final String getDocument(Method method) {
        Document document = this.getAnnotation(Document.class, method);
        return Objects.isNull(document) ? "" : document.value();
    }

    public final String getDocument(Field field) {
        Document document = this.getAnnotation(Document.class, field);
        return Objects.isNull(document) ? "" : document.value();
    }

    public final boolean isEntity(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            return false;
        }
        if (clazz.getName().equalsIgnoreCase(RootEntity.class.getName())) {
            return true;
        }
        return this.isEntity(clazz.getSuperclass());
    }

    public final boolean isModel(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            return false;
        }
        if (clazz.getName().equalsIgnoreCase(RootModel.class.getName())) {
            return true;
        }
        return this.isModel(clazz.getSuperclass());
    }

    @NotNull
    public final List<Field> getFieldList(Class<?> clazz) {
        Field[] fields;
        LinkedList<Field> fieldList = new LinkedList<Field>();
        if (Objects.isNull(clazz)) {
            return fieldList;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            fieldList.add(field);
        }
        if (this.isTheRootClass(clazz)) {
            return fieldList;
        }
        Class<?> superClass = clazz.getSuperclass();
        fieldList.addAll(this.getFieldList(superClass));
        return fieldList;
    }

    @NotNull
    public final List<String> getFieldNameList(@NotNull Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields) {
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }

    @Nullable
    private <A extends Annotation> A getAnnotation(Class<A> annotationClass, @NotNull Method method, Class<?> currentClass) {
        A annotation = method.getAnnotation(annotationClass);
        if (Objects.nonNull(annotation)) {
            return annotation;
        }
        if (this.isTheRootClass(currentClass)) {
            return null;
        }
        Class<?> superClass = currentClass.getSuperclass();
        if (Objects.isNull(superClass)) {
            return null;
        }
        List<Method> superMethods = Arrays.stream(superClass.getMethods()).toList();
        Method superMethod = superMethods.stream().filter(m -> m.getName().equals(method.getName())).findFirst().orElse(null);
        if (Objects.isNull(superMethod)) {
            return null;
        }
        return this.getAnnotation(annotationClass, superMethod, superClass);
    }
}

