/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.config.AirConfig;
import cn.hamm.airpower.enums.Result;
import cn.hamm.airpower.model.json.Json;
import cn.hamm.airpower.root.RootEntity;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    @Nullable
    public final <E extends RootEntity<E>> E getEntity(E entity) {
        Object object = this.get(this.getCacheKey(entity));
        if (Objects.isNull(object)) {
            return null;
        }
        String json = object.toString();
        if (Objects.isNull(json)) {
            return null;
        }
        return (E)((RootEntity)Json.parse(json, entity.getClass()));
    }

    @Nullable
    public final <E extends RootEntity<E>> E getEntity(String key, E entity) {
        Object object = this.get(key);
        if (Objects.isNull(object)) {
            return null;
        }
        String json = object.toString();
        if (Objects.isNull(json)) {
            return null;
        }
        return (E)((RootEntity)Json.parse(json, entity.getClass()));
    }

    public final <E extends RootEntity<E>> void deleteEntity(E entity) {
        this.del(this.getCacheKey(entity));
    }

    public final <E extends RootEntity<E>> void saveEntity(E entity) {
        this.saveEntity(entity, AirConfig.getGlobalConfig().getCacheExpireSecond());
    }

    public final <E extends RootEntity<E>> void saveEntity(E entity, long second) {
        this.set(this.getCacheKey(entity), Json.toString(entity), second);
    }

    public final <E extends RootEntity<E>> void saveEntity(String key, E entity) {
        this.saveEntity(key, entity, AirConfig.getGlobalConfig().getCacheExpireSecond());
    }

    public final <E extends RootEntity<E>> void saveEntity(String key, E entity, long second) {
        this.set(key, Json.toString(entity), second);
    }

    public final void setExpireSecond(String key, long second) {
        try {
            if (second > 0L) {
                this.redisTemplate.expire((Object)key, second, TimeUnit.SECONDS);
            }
        }
        catch (Exception exception) {
            log.error(Result.REDIS_ERROR.getMessage(), (Throwable)exception);
            Result.REDIS_ERROR.show();
        }
    }

    public final void clearAll(String pattern) {
        try {
            Set keys = this.redisTemplate.keys((Object)pattern);
            if (Objects.nonNull(keys)) {
                this.redisTemplate.delete((Collection)keys);
            }
        }
        catch (Exception exception) {
            log.error(Result.REDIS_ERROR.getMessage(), (Throwable)exception);
            Result.REDIS_ERROR.show();
        }
    }

    public final long getExpireSecond(String key) {
        try {
            return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            log.error(Result.REDIS_ERROR.getMessage(), (Throwable)exception);
            Result.REDIS_ERROR.show();
            return 0L;
        }
    }

    public final boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public final void del(String key) {
        try {
            this.redisTemplate.delete((Object)key);
        }
        catch (Exception exception) {
            log.error(Result.REDIS_ERROR.getMessage(), (Throwable)exception);
            Result.REDIS_ERROR.show();
        }
    }

    @Nullable
    public final Object get(String key) {
        try {
            return this.redisTemplate.opsForValue().get((Object)key);
        }
        catch (Exception exception) {
            log.error(Result.REDIS_ERROR.getMessage(), (Throwable)exception);
            Result.REDIS_ERROR.show();
            return null;
        }
    }

    public final void set(String key, Object value) {
        this.set(key, value, AirConfig.getGlobalConfig().getCacheExpireSecond());
    }

    public final void set(String key, Object value, long second) {
        try {
            if (second > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, second, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
        }
        catch (Exception exception) {
            log.error(Result.REDIS_ERROR.getMessage(), (Throwable)exception);
            Result.REDIS_ERROR.show();
        }
    }

    public final void publish(String channel, String message) {
        this.redisTemplate.convertAndSend(channel, (Object)message);
    }

    @NotNull
    private <E extends RootEntity<E>> String getCacheKey(@NotNull E entity) {
        return entity.getClass().getSimpleName() + "_" + entity.getId().toString();
    }
}

