/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.annotation.Permission;
import cn.hamm.airpower.model.Access;
import java.lang.reflect.Method;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AccessUtil {
    @NotNull
    public final Access getWhatNeedAccess(@NotNull Class<?> clazz, @NotNull Method method) {
        Permission permissionMethod;
        Access access = new Access();
        Permission permissionClass = clazz.getAnnotation(Permission.class);
        if (Objects.nonNull(permissionClass)) {
            access.setLogin(permissionClass.login());
            access.setAuthorize(permissionClass.login() && permissionClass.authorize());
        }
        if (Objects.nonNull(permissionMethod = method.getAnnotation(Permission.class))) {
            access.setLogin(permissionMethod.login());
            access.setAuthorize(permissionMethod.login() && permissionMethod.authorize());
        }
        return access;
    }

    @NotNull
    public final String getPermissionIdentity(@NotNull Class<?> clazz, @NotNull Method method) {
        return StringUtils.uncapitalize((String)clazz.getSimpleName().replaceAll("Controller", "")) + "_" + method.getName();
    }
}

