/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.root;

import cn.hamm.airpower.annotation.ReadOnly;
import cn.hamm.airpower.annotation.Search;
import cn.hamm.airpower.config.AirConfig;
import cn.hamm.airpower.enums.Result;
import cn.hamm.airpower.exception.ResultException;
import cn.hamm.airpower.interfaces.ITry;
import cn.hamm.airpower.model.Sort;
import cn.hamm.airpower.model.query.QueryPageRequest;
import cn.hamm.airpower.model.query.QueryPageResponse;
import cn.hamm.airpower.model.query.QueryRequest;
import cn.hamm.airpower.root.RootEntity;
import cn.hamm.airpower.root.RootRepository;
import cn.hamm.airpower.util.AirUtil;
import jakarta.persistence.Column;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.beans.FeatureDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.StringUtils;

public class RootService<E extends RootEntity<E>, R extends RootRepository<E>>
implements ITry {
    private static final Logger log = LoggerFactory.getLogger(RootService.class);
    private static final String SQL_LIKE_PERCENT = "%";
    @Autowired
    protected R repository;

    @NotNull
    protected E beforeAdd(@NotNull E source) {
        return source;
    }

    public final long add(@NotNull E source) {
        source = this.beforeAdd(source);
        Result.ERROR.whenNull(source, "\u63d0\u4ea4\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ((RootEntity)((RootEntity)((RootEntity)source).setId(null)).setIsDisabled(false)).setCreateTime(System.currentTimeMillis());
        if (Objects.isNull(((RootEntity)source).getRemark())) {
            ((RootEntity)source).setRemark("");
        }
        long id = this.saveToDatabase(source);
        E finalSource = source;
        this.execute(() -> this.afterAdd(id, finalSource), new Runnable[0]);
        return id;
    }

    protected void afterAdd(long id, @NotNull E source) {
    }

    @NotNull
    protected E beforeUpdate(@NotNull E source) {
        return source;
    }

    public final void update(@NotNull E source) {
        source = this.beforeUpdate(source);
        this.updateToDatabase(source);
        E finalSource = source;
        this.execute(() -> this.afterUpdate(finalSource.getId(), finalSource), () -> this.afterSaved(finalSource.getId(), finalSource));
    }

    public final void updateWithNull(@NotNull E source) {
        Result.PARAM_MISSING.whenNull(((RootEntity)source).getId(), String.format("\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u4f20\u5165%s\u7684ID!", AirUtil.getReflectUtil().getDescription(this.getEntityClass())));
        source = this.beforeUpdate(source);
        this.updateToDatabase(source, true);
        E finalSource = source;
        this.execute(() -> this.afterUpdate(finalSource.getId(), finalSource), () -> this.afterSaved(finalSource.getId(), finalSource));
    }

    protected void afterUpdate(long id, @NotNull E source) {
    }

    protected void afterSaved(long id, @NotNull E source) {
    }

    protected void beforeDisable(long id) {
    }

    public final void disable(long id) {
        this.beforeDisable(id);
        this.disableById(id);
        this.execute(() -> this.afterDisable(id), new Runnable[0]);
    }

    protected void afterDisable(long id) {
    }

    protected void beforeEnable(long id) {
    }

    public final void enable(long id) {
        this.beforeEnable(id);
        this.enableById(id);
        this.execute(() -> this.afterEnable(id), new Runnable[0]);
    }

    protected void afterEnable(long id) {
    }

    protected void beforeDelete(long id) {
    }

    public final void delete(long id) {
        this.beforeDelete(id);
        this.deleteById(id);
        this.execute(() -> this.afterDelete(id), new Runnable[0]);
    }

    protected void afterDelete(long id) {
    }

    @NotNull
    protected <T extends QueryRequest<E>> T beforeGetList(@NotNull T sourceRequestData) {
        return sourceRequestData;
    }

    @NotNull
    public final List<E> getList(QueryRequest<E> queryRequest) {
        queryRequest = Objects.requireNonNullElse(queryRequest, new QueryPageRequest());
        queryRequest.setFilter(Objects.requireNonNullElse((RootEntity)queryRequest.getFilter(), this.getNewInstance()));
        queryRequest = this.beforeGetList(queryRequest);
        List list = this.repository.findAll(this.createSpecification((RootEntity)queryRequest.getFilter(), false), this.createSort(queryRequest.getSort()));
        return this.afterGetList(list);
    }

    @NotNull
    public final List<E> filter(E filter) {
        QueryRequest<RootEntity> queryRequest = new QueryRequest<RootEntity>();
        queryRequest.setFilter(Objects.requireNonNullElse((RootEntity)queryRequest.getFilter(), filter));
        return this.repository.findAll(this.createSpecification(filter, true), this.createSort(queryRequest.getSort()));
    }

    @NotNull
    protected List<E> afterGetList(@NotNull List<E> list) {
        return list;
    }

    @NotNull
    protected <T extends QueryPageRequest<E>> T beforeGetPage(@NotNull T sourceRequestData) {
        return sourceRequestData;
    }

    @NotNull
    protected QueryPageResponse<E> afterGetPage(@NotNull QueryPageResponse<E> queryPageResponse) {
        return queryPageResponse;
    }

    @NotNull
    protected E beforeSaveToDatabase(@NotNull E entity) {
        return entity;
    }

    @NotNull
    protected List<Predicate> addSearchPredicate(@NotNull Root<E> root, @NotNull CriteriaBuilder builder, @NotNull E search) {
        return new ArrayList<Predicate>();
    }

    @NotNull
    public final E get(long id) {
        return this.afterGet(this.getById(id));
    }

    @Nullable
    public final E getMaybeNull(long id) {
        return this.afterGet(this.getByIdMaybeNull(id));
    }

    protected E afterGet(E result) {
        return result;
    }

    @NotNull
    public final QueryPageResponse<E> getPage(QueryPageRequest<E> queryPageRequest) {
        queryPageRequest = Objects.requireNonNullElse(queryPageRequest, new QueryPageRequest());
        queryPageRequest.setFilter(Objects.requireNonNullElse((RootEntity)queryPageRequest.getFilter(), this.getNewInstance()));
        queryPageRequest = this.beforeGetPage(queryPageRequest);
        Page pageData = this.repository.findAll(this.createSpecification((RootEntity)queryPageRequest.getFilter(), false), this.createPageable(queryPageRequest));
        QueryPageResponse<E> queryPageResponse = this.getResponsePageList(pageData);
        queryPageResponse.setSort(queryPageRequest.getSort());
        return this.afterGetPage(queryPageResponse);
    }

    protected final void disableById(long id) {
        E entity = this.get(id);
        this.saveToDatabase(((RootEntity)entity).setIsDisabled(true));
    }

    protected final void enableById(long id) {
        E entity = this.get(id);
        this.saveToDatabase(((RootEntity)entity).setIsDisabled(false));
    }

    protected final void deleteById(long id) {
        this.repository.deleteById((Object)id);
    }

    @Contract(value="_ -> param1")
    @NotNull
    protected final E ignoreReadOnlyFields(@NotNull E entity) {
        AirUtil.getReflectUtil().getFieldList(this.getEntityClass()).stream().filter(field -> Objects.nonNull(AirUtil.getReflectUtil().getAnnotation(ReadOnly.class, (Field)field))).forEach(field -> AirUtil.getReflectUtil().clearFieldValue(entity, (Field)field));
        return entity;
    }

    protected final void updateToDatabase(@NotNull E source) {
        this.updateToDatabase(source, false);
    }

    protected final void updateToDatabase(@NotNull E source, boolean withNull) {
        Result.ERROR.whenNull(source, "\u63d0\u4ea4\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Result.PARAM_MISSING.whenNull(((RootEntity)source).getId(), String.format("\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u4f20\u5165%s\u7684ID!", AirUtil.getReflectUtil().getDescription(this.getEntityClass())));
        this.saveToDatabase(source, withNull);
    }

    @NotNull
    private E getById(long id) {
        Result.PARAM_MISSING.whenNull(id, String.format("\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u4f20\u5165%s\u7684ID\uff01", AirUtil.getReflectUtil().getDescription(this.getEntityClass())));
        Optional optional = this.repository.findById((Object)id);
        if (optional.isPresent()) {
            return (E)((RootEntity)optional.get());
        }
        throw new ResultException(Result.DATA_NOT_FOUND, String.format("\u6ca1\u6709\u67e5\u8be2\u5230ID\u4e3a%s\u7684%s", id, AirUtil.getReflectUtil().getDescription(this.getEntityClass())));
    }

    @Nullable
    private E getByIdMaybeNull(long id) {
        try {
            return this.get(id);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private long saveToDatabase(@NotNull E entity) {
        return this.saveToDatabase(entity, false);
    }

    private long saveToDatabase(@NotNull E entity, boolean withNull) {
        this.checkUnique(entity);
        ((RootEntity)entity).setUpdateTime(System.currentTimeMillis());
        if (Objects.nonNull(((RootEntity)entity).getId())) {
            AirUtil.getEntityManager().clear();
            E existEntity = this.getById(((RootEntity)entity).getId());
            if (Objects.isNull(((RootEntity)existEntity).getRemark()) && Objects.isNull(((RootEntity)entity).getRemark())) {
                ((RootEntity)entity).setRemark("");
            }
            entity = withNull ? entity : this.getEntityForSave(entity, existEntity);
        }
        Object target = this.getNewInstance();
        BeanUtils.copyProperties(entity, target);
        target = this.beforeSaveToDatabase(target);
        target = (RootEntity)this.repository.saveAndFlush(target);
        AirUtil.getEntityManager().clear();
        return ((RootEntity)target).getId();
    }

    @Contract(value="_, _ -> param2")
    @NotNull
    private E getEntityForSave(@NotNull E sourceEntity, @NotNull E existEntity) {
        String[] nullProperties = this.getNullProperties(sourceEntity);
        BeanUtils.copyProperties(sourceEntity, existEntity, (String[])nullProperties);
        return existEntity;
    }

    private void checkUnique(@NotNull E entity) {
        List<Field> fields = AirUtil.getReflectUtil().getFieldList(this.getEntityClass());
        for (Field field : fields) {
            Object fieldValue;
            String fieldName = AirUtil.getReflectUtil().getDescription(field);
            Column annotation = AirUtil.getReflectUtil().getAnnotation(Column.class, field);
            if (Objects.isNull(annotation) || !annotation.unique() || Objects.isNull(fieldValue = AirUtil.getReflectUtil().getFieldValue(entity, field))) continue;
            E search = this.getNewInstance();
            AirUtil.getReflectUtil().setFieldValue(search, field, fieldValue);
            Example example = Example.of(search);
            Optional exist = this.repository.findOne(example);
            if (exist.isEmpty() || Objects.nonNull(((RootEntity)entity).getId()) && ((RootEntity)exist.get()).getId().equals(((RootEntity)entity).getId())) continue;
            Result.FORBIDDEN_EXIST.show(String.format("%s(ID:%s)\u5df2\u7ecf\u5b58\u5728\uff01", fieldName, fieldValue));
        }
    }

    @NotNull
    private E getNewInstance() {
        try {
            return (E)((RootEntity)this.getEntityClass().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception exception) {
            throw new ResultException(exception.getMessage());
        }
    }

    @NotNull
    private Class<E> getEntityClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    private String @NotNull [] getNullProperties(@NotNull E sourceEntity) {
        BeanWrapperImpl srcBean = new BeanWrapperImpl(sourceEntity);
        return (String[])Arrays.stream(srcBean.getPropertyDescriptors()).map(FeatureDescriptor::getName).filter(arg_0 -> RootService.lambda$getNullProperties$10((BeanWrapper)srcBean, arg_0)).toArray(String[]::new);
    }

    @NotNull
    private QueryPageResponse<E> getResponsePageList(@NotNull Page<E> data) {
        return new QueryPageResponse().setList(data.getContent()).setTotal(Math.toIntExact(data.getTotalElements())).setPageCount(data.getTotalPages()).setPage(new cn.hamm.airpower.model.Page().setPageSize(data.getPageable().getPageSize()).setPageNum(data.getPageable().getPageNumber() + 1));
    }

    @NotNull
    private org.springframework.data.domain.Sort createSort(Sort sort) {
        if (!StringUtils.hasText((String)(sort = Objects.requireNonNullElse(sort, new Sort())).getField())) {
            sort.setField(AirConfig.getGlobalConfig().getDefaultSortField());
        }
        if (!StringUtils.hasText((String)sort.getDirection())) {
            sort.setDirection(AirConfig.getGlobalConfig().getDefaultSortDirection());
        }
        if (!AirConfig.getGlobalConfig().getDefaultSortDirection().equals(sort.getDirection())) {
            return org.springframework.data.domain.Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)sort.getField())});
        }
        return org.springframework.data.domain.Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)sort.getField())});
    }

    @NotNull
    private Pageable createPageable(@NotNull QueryPageRequest<E> queryPageData) {
        cn.hamm.airpower.model.Page page = Objects.requireNonNullElse(queryPageData.getPage(), new cn.hamm.airpower.model.Page());
        page.setPageNum(Objects.requireNonNullElse(page.getPageNum(), 1));
        page.setPageSize(Objects.requireNonNullElse(page.getPageSize(), AirConfig.getGlobalConfig().getDefaultPageSize()));
        int pageNumber = Math.max(0, page.getPageNum() - 1);
        int pageSize = Math.max(1, queryPageData.getPage().getPageSize());
        return PageRequest.of((int)pageNumber, (int)pageSize, (org.springframework.data.domain.Sort)this.createSort(queryPageData.getSort()));
    }

    @NotNull
    private List<Predicate> getPredicateList(@NotNull From<?, ?> root, @NotNull CriteriaBuilder builder, @NotNull Object search, boolean isEqual) {
        ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
        List<Field> fields = AirUtil.getReflectUtil().getFieldList(search.getClass());
        block4: for (Field field : fields) {
            Search searchMode;
            Object fieldValue = AirUtil.getReflectUtil().getFieldValue(search, field);
            if (Objects.isNull(fieldValue) || !StringUtils.hasText((String)fieldValue.toString()) || Objects.isNull(searchMode = AirUtil.getReflectUtil().getAnnotation(Search.class, field))) continue;
            switch (searchMode.value()) {
                case JOIN: {
                    Join payload = root.join(field.getName(), JoinType.INNER);
                    predicateList.addAll(this.getPredicateList((From<?, ?>)payload, builder, fieldValue, isEqual));
                    continue block4;
                }
                case LIKE: {
                    if (isEqual) break;
                    predicateList.add(builder.like((Expression)root.get(field.getName()), fieldValue + SQL_LIKE_PERCENT));
                }
            }
            Predicate predicate = builder.equal((Expression)root.get(field.getName()), fieldValue);
            predicateList.add(predicate);
        }
        return predicateList;
    }

    private void addCreateAndUpdateTimePredicate(@NotNull Root<E> root, @NotNull CriteriaBuilder builder, @NotNull E search, @NotNull List<Predicate> predicateList) {
        this.addPredicateNonNull(root, predicateList, "createTime", (arg_0, arg_1) -> ((CriteriaBuilder)builder).greaterThanOrEqualTo(arg_0, arg_1), ((RootEntity)search).getCreateTimeFrom());
        this.addPredicateNonNull(root, predicateList, "createTime", (arg_0, arg_1) -> ((CriteriaBuilder)builder).lessThan(arg_0, arg_1), ((RootEntity)search).getCreateTimeTo());
        this.addPredicateNonNull(root, predicateList, "updateTime", (arg_0, arg_1) -> ((CriteriaBuilder)builder).greaterThanOrEqualTo(arg_0, arg_1), ((RootEntity)search).getUpdateTimeFrom());
        this.addPredicateNonNull(root, predicateList, "updateTime", (arg_0, arg_1) -> ((CriteriaBuilder)builder).lessThan(arg_0, arg_1), ((RootEntity)search).getUpdateTimeTo());
    }

    protected final <Y extends Comparable<? super Y>> void addPredicateNonNull(@NotNull Root<E> root, List<Predicate> predicateList, String fieldName, BiFunction<Expression<? extends Y>, Y, Predicate> expression, Y value) {
        if (Objects.nonNull(value)) {
            predicateList.add(expression.apply((Expression<Y>)root.get(fieldName), value));
        }
    }

    @Contract(pure=true)
    @NotNull
    private Specification<E> createSpecification(@NotNull E filter, boolean isEqual) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> this.createPredicate(root, criteriaQuery, criteriaBuilder, filter, isEqual);
    }

    private Predicate createPredicate(@NotNull Root<E> root, @NotNull CriteriaQuery<?> criteriaQuery, @NotNull CriteriaBuilder builder, @NotNull E filter, boolean isEqual) {
        List<Predicate> predicateList = this.getPredicateList((From<?, ?>)root, builder, filter, isEqual);
        predicateList.addAll(this.addSearchPredicate(root, builder, filter));
        this.addCreateAndUpdateTimePredicate(root, builder, filter, predicateList);
        Predicate[] predicates = new Predicate[predicateList.size()];
        criteriaQuery.where((Expression)builder.and(predicateList.toArray(predicates)));
        return criteriaQuery.getRestriction();
    }

    private static /* synthetic */ boolean lambda$getNullProperties$10(BeanWrapper srcBean, String name) {
        return Objects.isNull(srcBean.getPropertyValue(name));
    }
}

