/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.root;

import cn.hamm.airpower.annotation.Permission;
import cn.hamm.airpower.config.AirConfig;
import cn.hamm.airpower.enums.Result;
import cn.hamm.airpower.exception.ResultException;
import cn.hamm.airpower.interfaces.IAction;
import cn.hamm.airpower.interfaces.ITry;
import cn.hamm.airpower.model.json.Json;
import cn.hamm.airpower.model.json.JsonData;
import cn.hamm.airpower.util.AirUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Permission(login=false)
@RestController
@RequestMapping(value={""})
public class RootController
implements IAction,
ITry {
    private static final Logger log = LoggerFactory.getLogger(RootController.class);

    protected Json json(String message) {
        return new Json(message);
    }

    protected JsonData jsonData(Object data) {
        return new JsonData(data);
    }

    protected JsonData jsonData(Object data, String message) {
        return new JsonData(data, message);
    }

    protected final long getCurrentUserId() {
        try {
            String accessToken = AirUtil.getRequest().getHeader(AirConfig.getGlobalConfig().getAuthorizeHeader());
            return AirUtil.getSecurityUtil().getUserIdFromAccessToken(accessToken);
        }
        catch (Exception exception) {
            log.error("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)exception);
            throw new ResultException(Result.UNAUTHORIZED);
        }
    }
}

