/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.resolver;

import cn.hamm.airpower.config.AirConfig;
import cn.hamm.airpower.util.AirUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Component
public class AccessResolver
implements HandlerMethodArgumentResolver {
    public final boolean supportsParameter(@NotNull MethodParameter parameter) {
        Class clazz = parameter.getParameterType();
        return clazz == Long.class;
    }

    @NotNull
    public final @Unmodifiable Object resolveArgument(@NotNull MethodParameter parameter, ModelAndViewContainer mavContainer, @NotNull NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        String accessToken = Objects.nonNull(request) ? request.getHeader(AirConfig.getGlobalConfig().getAuthorizeHeader()) : null;
        return AirUtil.getSecurityUtil().getUserIdFromAccessToken(accessToken);
    }
}

