/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.interceptor.cache;

import cn.hamm.airpower.interceptor.cache.RequestBodyCacheWrapper;
import cn.hamm.airpower.util.AirUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
@WebFilter
public class RequestCacheFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RequestCacheFilter.class);

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (HttpMethod.GET.name().equalsIgnoreCase(request.getMethod())) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (!request.getContentType().contains("application/json")) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        try {
            if (AirUtil.getRequestUtil().isUploadRequest(servletRequest)) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            RequestBodyCacheWrapper wrapper = new RequestBodyCacheWrapper(httpServletRequest);
            filterChain.doFilter((ServletRequest)wrapper, servletResponse);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }
}

