/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.interceptor;

import cn.hamm.airpower.annotation.Filter;
import cn.hamm.airpower.model.json.JsonData;
import cn.hamm.airpower.model.query.QueryPageResponse;
import cn.hamm.airpower.root.RootModel;
import cn.hamm.airpower.util.AirUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseBodyInterceptor
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ResponseBodyInterceptor.class);

    @Contract(pure=true)
    public final boolean supports(@NotNull MethodParameter returnType, @NotNull Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public final Object beforeBodyWrite(Object body, @NotNull MethodParameter returnType, @NotNull MediaType selectedContentType, @NotNull Class<? extends HttpMessageConverter<?>> selectedConverterType, @NotNull ServerHttpRequest request, @NotNull ServerHttpResponse response) {
        Method method = (Method)this.getShareData("REQUEST_METHOD_KEY");
        if (Objects.isNull(method)) {
            return this.beforeResponseFinished(body, request, response);
        }
        return this.beforeResponseFinished(this.getResult(body, method), request, response);
    }

    @Contract(value="null, _ -> null")
    private <M extends RootModel<M>> Object getResult(Object result, Method method) {
        if (!(result instanceof JsonData)) {
            return result;
        }
        JsonData jsonData = (JsonData)result;
        if (Objects.isNull(jsonData.getData())) {
            return result;
        }
        Filter filter = AirUtil.getReflectUtil().getAnnotation(Filter.class, method);
        if (Objects.isNull(filter)) {
            return result;
        }
        if (Void.class.equals(filter.value())) {
            return result;
        }
        if (jsonData.getData() instanceof QueryPageResponse) {
            QueryPageResponse queryPageResponse = (QueryPageResponse)jsonData.getData();
            this.filterResponseListBy(filter, queryPageResponse.getList());
            return jsonData.setData(queryPageResponse);
        }
        Class<?> dataCls = jsonData.getData().getClass();
        if (jsonData.getData() instanceof Collection) {
            Collection collection = AirUtil.getCollectionUtil().getCollectWithoutNull((Collection)jsonData.getData(), dataCls);
            return jsonData.setData(this.filterResponseListBy(filter, collection.stream().toList()));
        }
        if (AirUtil.getReflectUtil().isModel(dataCls)) {
            return jsonData.setData(this.filterResponseBy(filter, (RootModel)jsonData.getData()));
        }
        return jsonData;
    }

    protected Object beforeResponseFinished(Object body, ServerHttpRequest request, ServerHttpResponse response) {
        return body;
    }

    @Nullable
    protected final Object getShareData(String key) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(requestAttributes)) {
            return null;
        }
        return requestAttributes.getAttribute(key, 0);
    }

    private <M extends RootModel<M>> M filterResponseBy(@NotNull Filter filter, @NotNull M data) {
        return data.filterResponseDataBy(filter.value());
    }

    @Contract(value="_, _ -> param2")
    private <M extends RootModel<M>> List<M> filterResponseListBy(@NotNull Filter filter, List<M> list) {
        try {
            list.forEach(item -> this.filterResponseBy(filter, item));
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        return list;
    }
}

