/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.interceptor;

import cn.hamm.airpower.config.AirConfig;
import cn.hamm.airpower.enums.Result;
import cn.hamm.airpower.exception.ResultException;
import cn.hamm.airpower.interceptor.document.ApiDocument;
import cn.hamm.airpower.model.json.Json;
import cn.hamm.airpower.model.json.JsonData;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
@ResponseStatus(value=HttpStatus.OK)
@ResponseBody
public class ExceptionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ExceptionInterceptor.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Json badRequestHandle(@NotNull MethodArgumentNotValidException exception) {
        log.error(exception.getMessage());
        BindingResult result = exception.getBindingResult();
        StringBuilder stringBuilder = new StringBuilder();
        if (!result.hasErrors()) {
            return new Json(Result.PARAM_INVALID);
        }
        if (!result.hasFieldErrors()) {
            return new Json(Result.PARAM_INVALID);
        }
        List errors = result.getFieldErrors();
        Iterator iterator = errors.iterator();
        if (iterator.hasNext()) {
            FieldError error = (FieldError)iterator.next();
            stringBuilder.append(String.format("%s(%s)", error.getDefaultMessage(), error.getField()));
        }
        return new Json(Result.PARAM_INVALID, stringBuilder.toString());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Json badRequestHandle(@NotNull ConstraintViolationException exception) {
        log.error(exception.getMessage());
        StringBuilder stringBuilder = new StringBuilder();
        Set errors = exception.getConstraintViolations();
        Iterator iterator = errors.iterator();
        if (iterator.hasNext()) {
            ConstraintViolation error = (ConstraintViolation)iterator.next();
            stringBuilder.append(String.format("%s(%s)", error.getMessage(), error.getInvalidValue().toString()));
        }
        return new Json(Result.PARAM_INVALID, stringBuilder.toString());
    }

    @ExceptionHandler(value={SQLIntegrityConstraintViolationException.class, DataIntegrityViolationException.class})
    public Json deleteUsingDataException(@NotNull Exception exception) {
        log.error(exception.getMessage());
        if (AirConfig.getGlobalConfig().isDebug()) {
            log.error(Result.FORBIDDEN_DELETE_USED.getMessage(), (Throwable)exception);
        }
        return new Json(Result.FORBIDDEN_DELETE_USED);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Json notFoundHandle(@NotNull NoHandlerFoundException exception, HttpServletResponse response) {
        String packageName;
        boolean result;
        String[] arr;
        log.error(exception.getMessage());
        if (AirConfig.getGlobalConfig().isEnableDocument() && (arr = exception.getRequestURL().split("/")).length > 1 && !(result = ApiDocument.writeEntityDocument(packageName = arr[arr.length - 1], response))) {
            response.reset();
            return new Json(Result.API_SERVICE_UNSUPPORTED);
        }
        return new Json(Result.API_SERVICE_UNSUPPORTED);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Json dataExceptionHandle(@NotNull HttpMessageNotReadableException exception) {
        log.error(exception.getMessage());
        return new Json(Result.REQUEST_CONTENT_TYPE_UNSUPPORTED, "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\u662f\u5426\u63a5\u53e3\u652f\u6301\u7684JSON");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Json methodExceptionHandle(@NotNull HttpRequestMethodNotSupportedException exception) {
        log.error(exception.getMessage());
        String supportedMethod = String.join((CharSequence)"/", Objects.requireNonNull(exception.getSupportedMethods()));
        return new Json(Result.REQUEST_METHOD_UNSUPPORTED, String.format("%s \u4e0d\u88ab\u652f\u6301\uff0c\u8bf7\u4f7f\u7528 %s \u65b9\u6cd5\u8bf7\u6c42", exception.getMethod(), supportedMethod));
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Json httpMediaTypeNotSupportedExceptionHandle(@NotNull HttpMediaTypeNotSupportedException exception) {
        log.error(exception.getMessage());
        if (AirConfig.getGlobalConfig().isDebug()) {
            log.error(Result.REQUEST_CONTENT_TYPE_UNSUPPORTED.getMessage(), (Throwable)exception);
        }
        return new Json(Result.REQUEST_CONTENT_TYPE_UNSUPPORTED, String.format("%s \u4e0d\u88ab\u652f\u6301\uff0c\u8bf7\u4f7f\u7528JSON\u8bf7\u6c42", Objects.requireNonNull(exception.getContentType()).getType()));
    }

    @ExceptionHandler(value={CannotCreateTransactionException.class})
    public Json databaseExceptionHandle(@NotNull CannotCreateTransactionException exception) {
        log.error(exception.getMessage());
        if (AirConfig.getGlobalConfig().isDebug()) {
            log.error(Result.DATABASE_ERROR.getMessage(), (Throwable)exception);
        }
        return new Json(Result.DATABASE_ERROR);
    }

    @ExceptionHandler(value={RedisConnectionFailureException.class})
    public Json redisExceptionHandle(@NotNull RedisConnectionFailureException exception) {
        log.error(exception.getMessage());
        if (AirConfig.getGlobalConfig().isDebug()) {
            log.error(Result.REDIS_ERROR.getMessage(), (Throwable)exception);
        }
        return new Json(Result.REDIS_ERROR);
    }

    @ExceptionHandler(value={ResultException.class})
    public JsonData customExceptionHandle(@NotNull ResultException exception) {
        log.error(exception.getMessage());
        if (AirConfig.getGlobalConfig().isDebug()) {
            log.error(Result.ERROR.getMessage(), (Throwable)exception);
        }
        return new JsonData(exception.getData(), exception.getMessage(), exception.getCode());
    }

    @ExceptionHandler(value={PropertyReferenceException.class})
    public Json propertyReferenceExceptionHandle(@NotNull PropertyReferenceException exception) {
        log.error(exception.getMessage());
        if (AirConfig.getGlobalConfig().isDebug()) {
            log.error(Result.DATABASE_UNKNOWN_FIELD.getMessage(), (Throwable)exception);
        }
        return new Json(Result.DATABASE_UNKNOWN_FIELD, String.format("\u6570\u636e\u5e93\u7f3a\u5c11\u5b57\u6bb5%s", exception.getPropertyName()));
    }

    @ExceptionHandler(value={InvalidDataAccessResourceUsageException.class})
    public Json invalidDataAccessResourceUsageExceptionHandle(@NotNull InvalidDataAccessResourceUsageException exception) {
        log.error(exception.getMessage());
        if (AirConfig.getGlobalConfig().isDebug()) {
            log.error(Result.DATABASE_TABLE_OR_FIELD_ERROR.getMessage(), (Throwable)exception);
        }
        return new Json(Result.DATABASE_TABLE_OR_FIELD_ERROR);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public Json maxUploadSizeExceededExceptionHandle(@NotNull MaxUploadSizeExceededException exception) {
        log.error(exception.getMessage());
        if (AirConfig.getGlobalConfig().isDebug()) {
            log.error(Result.FORBIDDEN_UPLOAD_MAX_SIZE.getMessage(), (Throwable)exception);
        }
        return new Json(Result.FORBIDDEN_UPLOAD_MAX_SIZE);
    }

    @ExceptionHandler(value={Exception.class, RuntimeException.class})
    public Object otherExceptionHandle(@NotNull Exception exception) {
        log.error(exception.getMessage());
        if (AirConfig.getGlobalConfig().isDebug()) {
            log.error(Result.ERROR.getMessage(), (Throwable)exception);
        }
        return new Json(Result.ERROR);
    }
}

