/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.interceptor;

import cn.hamm.airpower.config.AirConfig;
import cn.hamm.airpower.enums.Result;
import cn.hamm.airpower.interceptor.document.ApiDocument;
import cn.hamm.airpower.model.Access;
import cn.hamm.airpower.util.AirUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.lang.reflect.Method;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public abstract class AbstractRequestInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractRequestInterceptor.class);
    protected static final String REQUEST_METHOD_KEY = "REQUEST_METHOD_KEY";

    public final boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object object) {
        GetMapping getMapping;
        HandlerMethod handlerMethod = (HandlerMethod)object;
        Class clazz = handlerMethod.getBeanType();
        Method method = handlerMethod.getMethod();
        this.setShareData(REQUEST_METHOD_KEY, method);
        if (HttpMethod.GET.name().equalsIgnoreCase(request.getMethod()) && AirConfig.getGlobalConfig().isEnableDocument() && Objects.isNull(getMapping = AirUtil.getReflectUtil().getAnnotation(GetMapping.class, method))) {
            ApiDocument.writeApiDocument(response, clazz, method);
            return false;
        }
        this.beforeHandleRequest(request, response, clazz, method);
        Access access = AirUtil.getAccessUtil().getWhatNeedAccess(clazz, method);
        if (!access.isLogin()) {
            return true;
        }
        String accessToken = request.getHeader(AirConfig.getGlobalConfig().getAuthorizeHeader());
        String accessTokenFromParam = request.getParameter(AirConfig.getGlobalConfig().getAuthorizeHeader());
        if (StringUtils.hasText((String)accessTokenFromParam)) {
            accessToken = accessTokenFromParam;
        }
        Result.UNAUTHORIZED.whenEmpty(accessToken);
        Long userId = AirUtil.getSecurityUtil().getUserIdFromAccessToken(accessToken);
        if (access.isAuthorize()) {
            return this.checkPermissionAccess(userId, AirUtil.getAccessUtil().getPermissionIdentity(clazz, method), request);
        }
        return true;
    }

    protected abstract boolean checkPermissionAccess(Long var1, String var2, HttpServletRequest var3);

    protected void beforeHandleRequest(HttpServletRequest request, HttpServletResponse response, Class<?> clazz, Method method) {
    }

    protected final void setShareData(String key, Object value) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (Objects.nonNull(requestAttributes)) {
            requestAttributes.setAttribute(key, value, 0);
        }
    }

    @NotNull
    protected final String getRequestBody(HttpServletRequest request) {
        if (AirUtil.getRequestUtil().isUploadRequest(request)) {
            return "";
        }
        try {
            String line;
            StringBuilder requestBody = new StringBuilder();
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                requestBody.append(line);
            }
            return requestBody.toString();
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return "";
        }
    }
}

