/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.datasource;

import cn.hamm.airpower.config.AirConfig;
import cn.hamm.airpower.datasource.DataSourceResolver;
import cn.hamm.airpower.enums.Result;
import jakarta.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class DataSourceAspect {
    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.PostMapping)||@annotation(org.springframework.web.bind.annotation.GetMapping)||@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void pointCut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointCut()")
    public Object multipleDataSource(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Result.ERROR.when(!AirConfig.getGlobalConfig().isServiceRunning(), "\u670d\u52a1\u77ed\u6682\u7ef4\u62a4\u4e2d,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff1a\uff09");
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String database = request.getHeader(AirConfig.getGlobalConfig().getTenantHeader());
        if (!StringUtils.hasText((String)database)) {
            return proceedingJoinPoint.proceed();
        }
        DataSourceResolver.setDataSourceParam(database);
        try {
            Object object = proceedingJoinPoint.proceed();
            return object;
        }
        finally {
            DataSourceResolver.clearDataSourceParam();
        }
    }
}

