/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.validate.phone;

import cn.hamm.airpower.request.ValidateUtil;
import cn.hamm.airpower.validate.phone.Phone;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.springframework.util.StringUtils;

public class PhoneAnnotationValidator
implements ConstraintValidator<Phone, String> {
    boolean mobile = true;
    boolean tel = true;

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (!StringUtils.hasLength((String)value)) {
            return true;
        }
        if (!this.mobile && !this.tel) {
            return true;
        }
        if (!this.mobile) {
            return ValidateUtil.isTelPhone(value);
        }
        if (!this.tel) {
            return ValidateUtil.isMobilePhone(value);
        }
        return ValidateUtil.isMobilePhone(value) || ValidateUtil.isTelPhone(value);
    }

    public void initialize(Phone constraintAnnotation) {
        this.mobile = constraintAnnotation.mobile();
        this.tel = constraintAnnotation.tel();
    }
}

