/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.annotation.Description;
import cn.hamm.airpower.annotation.Document;
import cn.hamm.airpower.root.RootController;
import cn.hamm.airpower.root.RootEntity;
import cn.hamm.airpower.root.RootModel;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class ReflectUtil {
    public static boolean isTheRootClass(Class<?> clazz) {
        return clazz.getName().equals(RootController.class.getName()) || clazz.getName().equals(RootEntity.class.getName()) || clazz.getName().equals(Object.class.getName());
    }

    public static <A extends Annotation> A getAnnotation(Class<A> annotationClass, Method method) {
        return ReflectUtil.getAnnotation(annotationClass, method, method.getDeclaringClass());
    }

    public static <A extends Annotation> A getAnnotation(Class<A> annotationClass, Class<?> clazz) {
        A annotation = clazz.getAnnotation(annotationClass);
        if (Objects.nonNull(annotation)) {
            return annotation;
        }
        if (ReflectUtil.isTheRootClass(clazz)) {
            return null;
        }
        Class<?> superClass = clazz.getSuperclass();
        return ReflectUtil.getAnnotation(annotationClass, superClass);
    }

    public static <A extends Annotation> A getAnnotation(Class<A> annotationClass, Field field) {
        return field.getAnnotation(annotationClass);
    }

    public static String getDescription(Class<?> clazz) {
        Description description = clazz.getAnnotation(Description.class);
        if (Objects.nonNull(description)) {
            return description.value();
        }
        if (ReflectUtil.isTheRootClass(clazz)) {
            return clazz.getSimpleName();
        }
        Class<?> superClass = clazz.getSuperclass();
        return ReflectUtil.getDescription(superClass);
    }

    public static String getDescription(Method method) {
        return ReflectUtil.getDescription(method, method.getDeclaringClass());
    }

    public static String getDescription(Field field) {
        Description description = field.getAnnotation(Description.class);
        return Objects.isNull(description) ? field.getName() : description.value();
    }

    public static String getDocument(Class<?> clazz) {
        Document document = clazz.getAnnotation(Document.class);
        if (Objects.nonNull(document)) {
            return document.value();
        }
        if (ReflectUtil.isTheRootClass(clazz)) {
            return "";
        }
        Class<?> superClass = clazz.getSuperclass();
        return ReflectUtil.getDocument(superClass);
    }

    public static String getDocument(Method method) {
        return ReflectUtil.getDocument(method, method.getDeclaringClass());
    }

    public static String getDocument(Field field) {
        Document document = field.getAnnotation(Document.class);
        if (Objects.nonNull(document)) {
            return document.value();
        }
        return "";
    }

    public static boolean isEntity(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            return false;
        }
        if (clazz.getName().equalsIgnoreCase(RootEntity.class.getName())) {
            return true;
        }
        return ReflectUtil.isEntity(clazz.getSuperclass());
    }

    public static boolean isModel(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            return false;
        }
        if (clazz.getName().equalsIgnoreCase(RootModel.class.getName())) {
            return true;
        }
        return ReflectUtil.isModel(clazz.getSuperclass());
    }

    private static <A extends Annotation> A getAnnotation(Class<A> annotationClass, Method method, Class<?> currentClass) {
        A annotation = method.getAnnotation(annotationClass);
        if (Objects.nonNull(annotation)) {
            return annotation;
        }
        if (ReflectUtil.isTheRootClass(currentClass)) {
            return null;
        }
        Class<?> superClass = currentClass.getSuperclass();
        if (Objects.isNull(superClass)) {
            return null;
        }
        try {
            Method superMethod = superClass.getMethod(method.getName(), method.getParameterTypes());
            return ReflectUtil.getAnnotation(annotationClass, superMethod, superClass);
        }
        catch (NoSuchMethodException e) {
            superClass = superClass.getSuperclass();
            if (Objects.isNull(superClass)) {
                return null;
            }
            return ReflectUtil.getAnnotation(annotationClass, method, superClass);
        }
    }

    private static String getDescription(Method method, Class<?> currentClass) {
        Description description = method.getAnnotation(Description.class);
        if (Objects.nonNull(description)) {
            return description.value();
        }
        if (ReflectUtil.isTheRootClass(currentClass)) {
            return method.getName();
        }
        Class<?> superClass = currentClass.getSuperclass();
        if (Objects.isNull(superClass)) {
            return method.getName();
        }
        try {
            Method superMethod = superClass.getMethod(method.getName(), method.getParameterTypes());
            return ReflectUtil.getDescription(superMethod, superClass);
        }
        catch (NoSuchMethodException e) {
            superClass = superClass.getSuperclass();
            return ReflectUtil.getDescription(method, superClass);
        }
    }

    private static String getDocument(Method method, Class<?> currentClass) {
        Document document = method.getAnnotation(Document.class);
        if (Objects.nonNull(document)) {
            return document.value();
        }
        if (ReflectUtil.isTheRootClass(currentClass)) {
            return "";
        }
        Class<?> superClass = currentClass.getSuperclass();
        if (Objects.isNull(superClass)) {
            return "";
        }
        try {
            Method superMethod = superClass.getMethod(method.getName(), method.getParameterTypes());
            return ReflectUtil.getDocument(superMethod, superClass);
        }
        catch (NoSuchMethodException exception) {
            superClass = superClass.getSuperclass();
            return ReflectUtil.getDocument(method, superClass);
        }
    }

    public static List<Field> getFieldList(Class<?> clazz) {
        Field[] fields;
        LinkedList<Field> fieldList = new LinkedList<Field>();
        if (Objects.isNull(clazz)) {
            return fieldList;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            fieldList.add(field);
        }
        if (ReflectUtil.isTheRootClass(clazz)) {
            return fieldList;
        }
        Class<?> superClass = clazz.getSuperclass();
        fieldList.addAll(ReflectUtil.getFieldList(superClass));
        return fieldList;
    }

    public static List<String> getFieldNameList(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields) {
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }
}

