/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import java.util.concurrent.ThreadLocalRandom;
import org.springframework.util.StringUtils;

public class RandomUtil {
    public static final String BASE_NUMBER = "0123456789";
    public static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    public static final String BASE_CHAR_NUMBER_LOWER = "abcdefghijklmnopqrstuvwxyz0123456789";
    public static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz".toUpperCase() + "abcdefghijklmnopqrstuvwxyz0123456789";

    public static String randomString() {
        return RandomUtil.randomString(32);
    }

    public static String randomString(int length) {
        return RandomUtil.randomString(BASE_CHAR_NUMBER, length);
    }

    public static String randomNumbers(int length) {
        return RandomUtil.randomString(BASE_NUMBER, length);
    }

    public static String randomString(String baseString, int length) {
        if (!StringUtils.hasText((String)baseString)) {
            return "";
        }
        if (length < 1) {
            length = 1;
        }
        StringBuilder sb = new StringBuilder(length);
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = RandomUtil.randomInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }

    public static int randomInt() {
        return RandomUtil.getRandom().nextInt();
    }

    public static int randomInt(int exclude) {
        return RandomUtil.getRandom().nextInt(exclude);
    }

    public static int randomInt(int minInclude, int maxExclude) {
        return RandomUtil.randomInt(minInclude, maxExclude, true, false);
    }

    public static int randomInt(int min, int max, boolean includeMin, boolean includeMax) {
        if (!includeMin) {
            ++min;
        }
        if (includeMax) {
            ++max;
        }
        return RandomUtil.getRandom().nextInt(min, max);
    }

    private static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }
}

