/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.interfaces.IDictionary;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DictionaryUtil {
    private static final Logger log = LoggerFactory.getLogger(DictionaryUtil.class);

    public static <D extends IDictionary> D getDictionaryByKey(Class<D> enumClass, int key) {
        D[] objs;
        Method getKey = enumClass.getMethod("getKey", new Class[0]);
        for (D obj : objs = enumClass.getEnumConstants()) {
            int exitValue = (Integer)getKey.invoke(obj, new Object[0]);
            if (exitValue != key) continue;
            return (D)((IDictionary)obj);
        }
        return null;
    }

    @NotNull
    public static <D extends IDictionary> List<Map<String, String>> getDictionaryList(Class<D> clazz) {
        return DictionaryUtil.getDictionaryList(clazz, "key", "label");
    }

    @NotNull
    public static <D extends IDictionary> List<Map<String, String>> getDictionaryList(@NotNull Class<D> clazz, String ... params) {
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        for (IDictionary obj : (IDictionary[])clazz.getEnumConstants()) {
            HashMap<String, String> item = new HashMap<String, String>(params.length);
            for (String param : params) {
                try {
                    Method method = clazz.getMethod("get" + StringUtils.capitalize((String)param), new Class[0]);
                    item.put(param, method.invoke((Object)obj, new Object[0]).toString());
                }
                catch (Exception exception) {
                    log.error("\u83b7\u53d6\u679a\u4e3e\u5b57\u5178\u6570\u636e\u5931\u8d25", (Throwable)exception);
                }
            }
            mapList.add(item);
        }
        return mapList;
    }
}

