/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.security;

import cn.hamm.airpower.config.GlobalConfig;
import cn.hamm.airpower.result.Result;
import cn.hamm.airpower.util.RandomUtil;
import cn.hamm.airpower.util.redis.RedisUtil;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SecurityUtil {
    private final String ACCESS_TOKEN_PREFIX = "access_token_";
    @Autowired
    private RedisUtil<?> redisUtil;
    @Autowired
    private GlobalConfig globalConfig;

    public Long getUserIdFromAccessToken(String accessToken) {
        Object data = this.redisUtil.get("access_token_" + accessToken);
        if (Objects.nonNull(data)) {
            return Long.valueOf(data.toString());
        }
        Result.UNAUTHORIZED.show("\u83b7\u53d6\u8eab\u4efd\u4fe1\u606f\u5931\u8d25,\u8bf7\u91cd\u65b0\u767b\u5f55!");
        return null;
    }

    public String createAccessToken(Long userId) {
        String accessToken = RandomUtil.randomString();
        try {
            this.getUserIdFromAccessToken(accessToken);
            return this.createAccessToken(userId);
        }
        catch (Exception ignored) {
            this.redisUtil.set("access_token_" + accessToken, userId, this.globalConfig.getAuthorizeExpireTime());
            return accessToken;
        }
    }
}

