/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.security;

import cn.hamm.airpower.result.Result;
import cn.hamm.airpower.result.ResultException;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaHelper {
    private static final Logger log = LoggerFactory.getLogger(RsaHelper.class);
    private final int CRYPT_KEY_SIZE = 2048;
    private final String CRYPT_METHOD = "RSA";
    private String publicKey;
    private String privateKey;

    public String publicKeyEncode(String sourceContent) {
        try {
            int blockSize = 245;
            PublicKey publicKey = this.getPublicKey(this.publicKey);
            return this.encodeByKey(sourceContent, publicKey, blockSize);
        }
        catch (Exception exception) {
            log.error("\u516c\u94a5\u52a0\u5bc6\u5931\u8d25", (Throwable)exception);
            throw new ResultException(Result.ERROR);
        }
    }

    public String privateKeyDecode(String encryptedContent) {
        try {
            int blockSize = 256;
            PrivateKey privateKey = this.getPrivateKey(this.privateKey);
            return this.decodeByKey(encryptedContent, privateKey, blockSize);
        }
        catch (Exception exception) {
            log.error("\u79c1\u94a5\u89e3\u5bc6\u5931\u8d25", (Throwable)exception);
            throw new ResultException(Result.ERROR);
        }
    }

    public String privateKeyEncode(String sourceContent) {
        try {
            int blockSize = 245;
            PrivateKey privateKey = this.getPrivateKey(this.privateKey);
            return this.encodeByKey(sourceContent, privateKey, blockSize);
        }
        catch (Exception exception) {
            log.error("\u79c1\u94a5\u52a0\u5bc6\u5931\u8d25", (Throwable)exception);
            throw new ResultException(Result.ERROR);
        }
    }

    public String publicKeyDecode(String encryptedContent) {
        try {
            int blockSize = 256;
            PublicKey publicKey = this.getPublicKey(this.publicKey);
            return this.decodeByKey(encryptedContent, publicKey, blockSize);
        }
        catch (Exception exception) {
            log.error("\u516c\u94a5\u89e3\u5bc6\u5931\u8d25", (Throwable)exception);
            throw new ResultException(Result.ERROR);
        }
    }

    private String decodeByKey(String encryptedContent, Key key, int blockSize) throws Exception {
        byte[] srcBytes = Base64.getDecoder().decode(encryptedContent);
        Cipher deCipher = Cipher.getInstance("RSA");
        deCipher.init(2, key);
        byte[] resultBytes = this.rsaDoFinal(deCipher, srcBytes, blockSize);
        return new String(resultBytes);
    }

    private String encodeByKey(String sourceContent, Key key, int blockSize) throws Exception {
        byte[] srcBytes = sourceContent.getBytes();
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, key);
        byte[] resultBytes = this.rsaDoFinal(cipher, srcBytes, blockSize);
        return Base64.getEncoder().encodeToString(resultBytes);
    }

    private PublicKey getPublicKey(String publicKeyString) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyString));
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }

    private PrivateKey getPrivateKey(String privateKeyString) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec private8KeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKeyString));
        return keyFactory.generatePrivate(private8KeySpec);
    }

    private byte[] rsaDoFinal(Cipher cipher, byte[] sourceBytes, int blockSize) throws Exception {
        Result.ERROR.when(blockSize <= 0, "\u5206\u6bb5\u5927\u5c0f\u5fc5\u987b\u5927\u4e8e0");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int inputLength = sourceBytes.length;
        int currentOffSet = 0;
        int index = 0;
        while (inputLength - currentOffSet > 0) {
            byte[] cacheBytes = cipher.doFinal(sourceBytes, currentOffSet, Math.min(inputLength - currentOffSet, blockSize));
            byteArrayOutputStream.write(cacheBytes, 0, cacheBytes.length);
            currentOffSet = ++index * blockSize;
        }
        byte[] data = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return data;
    }

    public RsaHelper setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public RsaHelper setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }
}

