/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.security;

import cn.hamm.airpower.config.CookieConfig;
import jakarta.servlet.http.Cookie;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CookieUtil {
    @Autowired
    private CookieConfig cookieConfig;

    public Cookie getCookie(String key, String value) {
        Cookie cookie = new Cookie(key, value);
        cookie.setHttpOnly(this.cookieConfig.isCookieHttpOnly());
        cookie.setMaxAge(this.cookieConfig.getCookieMaxAge());
        cookie.setSecure(this.cookieConfig.isCookieSecurity());
        cookie.setPath(cookie.getPath());
        return cookie;
    }

    public Cookie getAuthorizeCookie(String value) {
        return this.getCookie(this.cookieConfig.getAuthCookieName(), value);
    }
}

