/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.root;

import cn.hamm.airpower.config.GlobalConfig;
import cn.hamm.airpower.interfaces.IAction;
import cn.hamm.airpower.result.Result;
import cn.hamm.airpower.result.json.Json;
import cn.hamm.airpower.result.json.JsonData;
import cn.hamm.airpower.security.Permission;
import cn.hamm.airpower.security.SecurityUtil;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Permission(login=false)
@RestController
@RequestMapping(value={""})
public class RootController
implements IAction {
    private static final Logger log = LoggerFactory.getLogger(RootController.class);
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected GlobalConfig globalConfig;
    @Autowired
    private SecurityUtil securityUtil;

    protected Json json(String message) {
        return new Json(message);
    }

    protected JsonData jsonData(Object data) {
        return new JsonData(data);
    }

    protected JsonData jsonData(Object data, String message) {
        return new JsonData(data, message);
    }

    protected final long getCurrentUserId() {
        try {
            String accessToken = this.request.getHeader(this.globalConfig.getAuthorizeHeader());
            return this.securityUtil.getUserIdFromAccessToken(accessToken);
        }
        catch (Exception exception) {
            log.error("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)exception);
            Result.UNAUTHORIZED.show("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25,\u8bf7\u91cd\u65b0\u767b\u5f55\u540e\u5c1d\u8bd5");
            return 0L;
        }
    }
}

