/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.result.json;

import cn.hamm.airpower.result.IResult;
import cn.hamm.airpower.result.Result;
import cn.hamm.airpower.result.ResultException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Json
implements IResult {
    private static final Logger log = LoggerFactory.getLogger(Json.class);
    private int code = Result.SUCCESS.getCode();
    private String message = Result.SUCCESS.getMessage();

    public Json(String message) {
        this.message = message;
    }

    public Json(Result result) {
        this.code = result.getCode();
        this.message = result.getMessage();
    }

    public Json(Result result, String message) {
        this.code = result.getCode();
        this.message = message;
    }

    public Json(ResultException result, String message) {
        this.code = result.getCode();
        this.message = message;
    }

    @Nullable
    public static <E> E parse(String json, Class<E> clazz) {
        try {
            return (E)Json.getObjectMapper().readValue(json, clazz);
        }
        catch (JsonProcessingException exception) {
            log.error("JSON\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u5931\u8d25", (Throwable)exception);
            return null;
        }
    }

    @Nullable
    public static String toString(Object object) {
        try {
            return Json.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException exception) {
            log.error("\u5bf9\u8c61\u8f6cJSON\u5b57\u7b26\u4e32\u5931\u8d25", (Throwable)exception);
            return null;
        }
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public Json setCode(int code) {
        this.code = code;
        return this;
    }

    public Json setMessage(String message) {
        this.message = message;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Json)) {
            return false;
        }
        Json other = (Json)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Json;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "Json(code=" + this.getCode() + ", message=" + this.getMessage() + ")";
    }

    public Json(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public Json() {
    }
}

