/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.response;

import cn.hamm.airpower.query.QueryPageResponse;
import cn.hamm.airpower.response.Filter;
import cn.hamm.airpower.result.json.JsonData;
import cn.hamm.airpower.root.RootModel;
import cn.hamm.airpower.util.ReflectUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ResponseAspect {
    private static final Logger log = LoggerFactory.getLogger(ResponseAspect.class);

    @Pointcut(value="@annotation(cn.hamm.airpower.response.Filter)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public <M extends RootModel<M>> Object responseFilter(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = signature.getMethod();
        Class<?> returnCls = method.getReturnType();
        Object result = proceedingJoinPoint.proceed();
        if (!JsonData.class.equals(returnCls)) {
            return result;
        }
        Filter filter = method.getAnnotation(Filter.class);
        if (Objects.isNull(filter)) {
            return result;
        }
        JsonData jsonData = (JsonData)result;
        Class<?> dataCls = jsonData.getData().getClass();
        if (ArrayList.class.equals(dataCls)) {
            List list = (List)jsonData.getData();
            jsonData.setData(this.filterResponseListBy(filter, list));
            return jsonData;
        }
        if (QueryPageResponse.class.equals(dataCls)) {
            QueryPageResponse queryPageResponse = (QueryPageResponse)jsonData.getData();
            List list = queryPageResponse.getList();
            this.filterResponseListBy(filter, list);
            jsonData.setData(queryPageResponse.setList(list));
            return jsonData;
        }
        if (ReflectUtil.isModel(dataCls)) {
            jsonData.setData(this.filterResponseBy(filter, (RootModel)jsonData.getData()));
        }
        return jsonData;
    }

    private <M extends RootModel<M>> M filterResponseBy(Filter filter, M data) {
        return data.filterResponseDataBy(Objects.isNull(filter) ? Void.class : filter.value());
    }

    private <M extends RootModel<M>> List<M> filterResponseListBy(Filter filter, List<M> list) {
        try {
            for (RootModel item : list) {
                this.filterResponseBy(filter, item);
            }
        }
        catch (Exception exception) {
            log.error("\u8fc7\u6ee4\u6570\u636e\u5931\u8d25", (Throwable)exception);
        }
        return list;
    }
}

