/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.interceptor.document;

import cn.hamm.airpower.annotation.ReadOnly;
import cn.hamm.airpower.result.json.Json;
import cn.hamm.airpower.util.DictionaryUtil;
import cn.hamm.airpower.util.ReflectUtil;
import cn.hamm.airpower.validate.dictionary.Dictionary;
import cn.hamm.airpower.validate.phone.Phone;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;

public class ApiDocument {
    private static final Logger log = LoggerFactory.getLogger(ApiDocument.class);
    private static final String PACKAGE_SPLIT = ".";
    private String title;
    private String document;
    private List<ApiRequestParam> requestParamList = new ArrayList<ApiRequestParam>();

    public static void writeApiDocument(HttpServletResponse response, Class<?> clazz, Method method) {
        ApiDocument apiDocument = new ApiDocument();
        String className = ReflectUtil.getDescription(clazz);
        String methodName = ReflectUtil.getDescription(method);
        apiDocument.setTitle(className + " " + methodName + " Api\u63a5\u53e3\u6587\u6863");
        apiDocument.setDocument(ReflectUtil.getDocument(method));
        apiDocument.setRequestParamList(ApiDocument.getRequestParamList(clazz, method));
        String json = Json.toString(apiDocument);
        String html = "<!DOCTYPE html>\n      <html>\n          <head>\n              <title>AirPower4J \u63a5\u53e3\u6587\u6863</title>\n              <meta name=\"referrer\" content=\"never\">\n              <meta charset=\"UTF-8\">\n              <meta name=\"viewport\" content=\"width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no\" />\n              <link rel=\"stylesheet\" href=\"//at.alicdn.com/t/c/font_666204_kf3f5tzpd8f.css\">\n              <link rel=\"stylesheet\" href=\"//cdn.hamm.cn/css/element.css\">\n              <link rel=\"icon\" href=\"//cdn.hamm.cn/favicon.ico\">\n              <style>\n              .dictionary{\n                  display: flex;\n                  flex-direction: row;\n                  align-items: center;\n                  min-width: 200px;\n              }\n              .dictionary .key{\n                  color: red;\n              }\n              .dictionary .label{\n                  flex: 1;\n                  width: 0;\n              }\n              .body{\n                  position: absolute;\n                  left: 10%;\n                  right: 10%;\n                  top: 0;\n                  bottom: 0;\n                  display: flex;\n                  flex-direction: column;\n                  padding: 40px;\n              }\n              .body .card{\n                  flex: 1;\n                  height: 0;\n                  overflow: hidden;\n                  overflow-y: auto;\n              }\n              .body .header{\n                  font-size: 24px;\n                  font-weight: bold;\n                  padding: 20px 0px;\n              }\n              .body .desc{\n                  font-size: 14px;\n                  color: #999;\n                  background: #f5f5f5;\n                  padding: 10px 20px;\n                  margin-bottom: 20px;\n                  border-radius: 8px;\n              }\n              h2 {\n                  font-size: 16px;\n                  font-weight: bold;\n                  margin-top: 40px;\n              }\n              .content{\n                  display: flex;\n                  flex-direction: row;\n                  align-items: center;\n              }\n              .content .method{\n                  background: #666;\n                  color: white;\n                  padding: 2px 8px;\n                  font-size: 12px;\n                  border-radius: 5px;\n              }\n              .content .url{\n                  margin-left: 20px;\n                  color: #159;\n              }\n              a{\n                color: orangered;\n                text-decoration: none;\n              }\n              </style>\n          </head>\n          <body>\n              <div id=\"app\" v-cloak>\n                  <div class=\"body\">\n                      <div class=\"header\">{{api.title}} <a href=\"javascript:history.go(-1);\"> \u8fd4\u56de </a></div>\n                      <div class=\"desc\" v-if=\"api.document\">{{api.document}}</div>\n                      <div class=\"card\">\n                          <h2>\u8bf7\u6c42\u65b9\u5f0f</h2>\n                          <div class=\"content\">\n                              <div class=\"method\">POST</div> <div class=\"url\">{{url}}</div>\n                          </div>\n                          <h2>\u8bf7\u6c42\u53c2\u6570</h2>\n                          <el-table class=\"table\" stripe size=\"medium\" :data=\"api.requestParamList\" default-expand-all :tree-props=\"{children: 'children', hasChildren: 'hasChildren'}\">\n                              <el-table-column prop=\"name\" label=\"\u53c2\u6570Key\" ></el-table-column>\n                              <el-table-column prop=\"description\" label=\"\u53c2\u6570\u540d\u79f0\" width=\"200\"></el-table-column>\n                              <el-table-column prop=\"type\" width=\"150\" label=\"\u6570\u636e\u7c7b\u578b\">\n                                  <template slot-scope=\"scope\">\n                                    <el-link :href=\"scope.row.link\" v-if=\"scope.row.link\">{{ scope.row.type }}</el-link>\n                                    <template v-else>{{ scope.row.type }}</template>\n                                  </template>\n                              </el-table-column>\n                              <el-table-column label=\"\u5176\u4ed6\u8bf4\u660e\">\n                                  <template slot-scope=\"scope\">\n                                      <el-tag size=\"small\" v-if=\"scope.row.required\">\u5fc5\u586b</el-tag>\n                                      <el-tag size=\"small\" v-if=\"scope.row.phone\">\u7535\u8bdd</el-tag>\n                                      <el-tag size=\"small\" v-if=\"scope.row.email\">\u90ae\u7bb1</el-tag>\n                                      <el-dropdown v-if=\"scope.row.dictionary.length>0\">\n                                          <el-tag size=\"small\">\u5b57\u5178</el-tag>\n                                          <el-dropdown-menu slot=\"dropdown\">\n                                              <el-dropdown-item v-for=\"item in scope.row.dictionary\">\n                                                  <div class=\"dictionary\">\n                                                      <div class=\"label\">{{item.label}}</div>\n                                                      <div class=\"key\">{{item.key}}</div>\n                                                  </div>\n                                              </el-dropdown-item>\n                                          </el-dropdown-menu>\n                                      </el-dropdown>\n                                  </template>\n                              </el-table-column>\n                              <el-table-column prop=\"document\" label=\"\u5907\u6ce8\u8bf4\u660e\"></el-table-column>\n                          </el-table>\n                      </div>\n                  </div>\n              </div>\n          </body>\n          <script src=\"//cdn.hamm.cn/js/vue-2.6.10.min.js\"></script>\n          <script src=\"//cdn.hamm.cn/js/axios.min.js\"></script>\n          <script src=\"//cdn.hamm.cn/js/element.js\"></script>\n          <script src=\"//cdn.hamm.cn/js/vue-clipboard.min.js\"></script>\n          <script>\n          const json =\n" + json + "           </script>\n           <script>\n           new Vue({\n               el: '#app',\n               data() {\n                   return {\n                       url: window.location.pathname,\n                       api: json,\n                   }\n               },\n               created() {\n                   console.log(this.api)\n                   window.document.title = this.api.title + \" - AirPower4J\"\n                   this.api.requestParamList.sort((a,b)=>{\n                               if(a.required){\n                                   return -1;\n                               }\n                               if(b.required){\n                                   return 1;\n                               }\n                           })\n               },\n               updated() {},\n               methods: {}\n           });\n           </script>\n\n       </html>\n";
        try {
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write(html);
        }
        catch (IOException exception) {
            log.error("\u8f93\u51fa\u6587\u6863\u5931\u8d25", (Throwable)exception);
        }
    }

    private static List<ApiRequestParam> getRequestParamList(Class<?> currentClass, Method method) {
        Parameter[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return new ArrayList<ApiRequestParam>();
        }
        Parameter parameter = parameters[0];
        ArrayList<ApiRequestParam> params = new ArrayList<ApiRequestParam>();
        RequestBody requestBody = parameter.getAnnotation(RequestBody.class);
        if (Objects.isNull(requestBody)) {
            return params;
        }
        Class action = Void.class;
        Validated validated = parameter.getAnnotation(Validated.class);
        if (Objects.nonNull(validated)) {
            if (validated.value().length == 0) {
                return params;
            }
            action = validated.value()[0];
        }
        Class paramClass = parameter.getType();
        if (!parameter.getParameterizedType().getTypeName().contains(PACKAGE_SPLIT)) {
            paramClass = (Class)((ParameterizedType)currentClass.getGenericSuperclass()).getActualTypeArguments()[0];
        }
        List<Field> fields = ReflectUtil.getFieldList(paramClass);
        return ApiDocument.getFieldList(fields, currentClass, action);
    }

    private static List<ApiRequestParam> getFieldList(List<Field> fields, Class<?> currentClass, Class<?> action) {
        ArrayList<ApiRequestParam> params = new ArrayList<ApiRequestParam>();
        for (Field field : fields) {
            Email email;
            Phone phone;
            Dictionary dictionary;
            ReadOnly readOnly = field.getAnnotation(ReadOnly.class);
            if (Objects.nonNull(readOnly)) continue;
            ApiRequestParam apiRequestParam = new ApiRequestParam();
            apiRequestParam.setName(field.getName());
            apiRequestParam.setDescription(ReflectUtil.getDescription(field));
            apiRequestParam.setDocument(ReflectUtil.getDocument(field));
            apiRequestParam.setType(field.getType().getSimpleName());
            if (ReflectUtil.isModel(field.getType())) {
                apiRequestParam.setLink(field.getType().getName());
            }
            if (!field.getGenericType().getTypeName().contains(PACKAGE_SPLIT)) {
                Class clazz = (Class)((ParameterizedType)currentClass.getGenericSuperclass()).getActualTypeArguments()[0];
                apiRequestParam.setType(clazz.getSimpleName());
                if (ReflectUtil.isModel(clazz)) {
                    apiRequestParam.setLink(clazz.getName());
                }
            }
            NotNull notNull = field.getAnnotation(NotNull.class);
            NotBlank notBlank = field.getAnnotation(NotBlank.class);
            if (!action.equals(Void.class)) {
                if (Objects.nonNull(notBlank) && Arrays.stream(notBlank.groups()).toList().contains(action)) {
                    apiRequestParam.setRequired(true);
                }
                if (Objects.nonNull(notNull) && Arrays.stream(notNull.groups()).toList().contains(action)) {
                    apiRequestParam.setRequired(true);
                }
            }
            if (Objects.nonNull(dictionary = field.getAnnotation(Dictionary.class)) && Arrays.stream(dictionary.groups()).toList().contains(action)) {
                apiRequestParam.setDictionary(DictionaryUtil.getDictionaryList(dictionary.value()));
            }
            if (Objects.nonNull(phone = field.getAnnotation(Phone.class)) && Arrays.stream(phone.groups()).toList().contains(action) && (phone.mobile() || phone.tel())) {
                apiRequestParam.setPhone(true);
            }
            if (Objects.nonNull(email = field.getAnnotation(Email.class)) && Arrays.stream(email.groups()).toList().contains(action)) {
                apiRequestParam.setEmail(true);
            }
            params.add(apiRequestParam);
        }
        return params;
    }

    public static boolean writeEntityDocument(String packageName, HttpServletResponse response) {
        System.out.println(packageName);
        try {
            Class<?> clazz = Class.forName(packageName);
            if (!ReflectUtil.isModel(clazz)) {
                return false;
            }
            List<ApiRequestParam> params = ApiDocument.getFieldList(ReflectUtil.getFieldList(clazz), clazz, Void.class);
            ApiDocument apiDocument = new ApiDocument();
            apiDocument.setTitle(ReflectUtil.getDescription(clazz) + " " + clazz.getSimpleName());
            apiDocument.setDocument(ReflectUtil.getDocument(clazz));
            apiDocument.setRequestParamList(params);
            String json = Json.toString(apiDocument);
            String html = "<!DOCTYPE html>\n      <html>\n          <head>\n              <title>AirPower4J \u7c7b\u6587\u6863</title>\n              <meta name=\"referrer\" content=\"never\">\n              <meta charset=\"UTF-8\">\n              <meta name=\"viewport\" content=\"width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no\" />\n              <link rel=\"stylesheet\" href=\"//at.alicdn.com/t/c/font_666204_kf3f5tzpd8f.css\">\n              <link rel=\"stylesheet\" href=\"//cdn.hamm.cn/css/element.css\">\n              <link rel=\"icon\" href=\"//cdn.hamm.cn/favicon.ico\">\n              <style>\n              .dictionary{\n                  display: flex;\n                  flex-direction: row;\n                  align-items: center;\n                  min-width: 200px;\n              }\n              .dictionary .key{\n                  color: red;\n              }\n              .dictionary .label{\n                  flex: 1;\n                  width: 0;\n              }\n              .body{\n                  position: absolute;\n                  left: 10%;\n                  right: 10%;\n                  top: 0;\n                  bottom: 0;\n                  display: flex;\n                  flex-direction: column;\n                  padding: 40px;\n              }\n              .body .card{\n                  flex: 1;\n                  height: 0;\n                  overflow: hidden;\n                  overflow-y: auto;\n              }\n              .body .header{\n                  font-size: 24px;\n                  font-weight: bold;\n                  padding: 20px 0px;\n              }\n              .body .desc{\n                  font-size: 14px;\n                  color: #999;\n                  background: #f5f5f5;\n                  padding: 10px 20px;\n                  margin-bottom: 20px;\n                  border-radius: 8px;\n              }\n              h2 {\n                  font-size: 16px;\n                  font-weight: bold;\n                  margin-top: 40px;\n              }\n              .content{\n                  display: flex;\n                  flex-direction: row;\n                  align-items: center;\n              }\n              .content .method{\n                  background: #666;\n                  color: white;\n                  padding: 2px 8px;\n                  font-size: 12px;\n                  border-radius: 5px;\n              }\n              .content .url{\n                  margin-left: 20px;\n                  color: #159;\n              }\n              a{\n                color: orangered;\n                text-decoration: none;\n              }\n              </style>\n          </head>\n          <body>\n              <div id=\"app\" v-cloak>\n                  <div class=\"body\">\n                    <div class=\"header\">{{api.title}} <a href=\"javascript:history.go(-1);\"> \u8fd4\u56de </a></div>\n                      <div class=\"desc\" v-if=\"api.document\">{{api.document}}</div>\n                      <div class=\"card\">\n                          <h2>\u5c5e\u6027\u5217\u8868</h2>\n                          <el-table class=\"table\" stripe size=\"medium\" :data=\"api.requestParamList\" default-expand-all :tree-props=\"{children: 'children', hasChildren: 'hasChildren'}\">\n                              <el-table-column prop=\"name\" label=\"\u5c5e\u6027\" ></el-table-column>\n                              <el-table-column prop=\"description\" label=\"\u5c5e\u6027\u8bf4\u660e\" width=\"200\"></el-table-column>\n                              <el-table-column prop=\"type\" width=\"150\" label=\"\u6570\u636e\u7c7b\u578b\">\n                                  <template slot-scope=\"scope\">\n                                    <el-link :href=\"scope.row.link\" v-if=\"scope.row.link\">{{ scope.row.type }}</el-link>\n                                    <template v-else>{{ scope.row.type }}</template>\n                                  </template>\n                              </el-table-column>\n                              <el-table-column label=\"\u5176\u4ed6\u8bf4\u660e\">\n                                  <template slot-scope=\"scope\">\n                                      <el-tag size=\"small\" v-if=\"scope.row.required\">\u5fc5\u586b</el-tag>\n                                      <el-tag size=\"small\" v-if=\"scope.row.phone\">\u7535\u8bdd</el-tag>\n                                      <el-tag size=\"small\" v-if=\"scope.row.email\">\u90ae\u7bb1</el-tag>\n                                      <el-dropdown v-if=\"scope.row.dictionary.length>0\">\n                                          <el-tag size=\"small\">\u5b57\u5178</el-tag>\n                                          <el-dropdown-menu slot=\"dropdown\">\n                                              <el-dropdown-item v-for=\"item in scope.row.dictionary\">\n                                                  <div class=\"dictionary\">\n                                                      <div class=\"label\">{{item.label}}</div>\n                                                      <div class=\"key\">{{item.key}}</div>\n                                                  </div>\n                                              </el-dropdown-item>\n                                          </el-dropdown-menu>\n                                      </el-dropdown>\n                                  </template>\n                              </el-table-column>\n                              <el-table-column prop=\"document\" label=\"\u5907\u6ce8\u8bf4\u660e\"></el-table-column>\n                          </el-table>\n                      </div>\n                  </div>\n              </div>\n          </body>\n          <script src=\"//cdn.hamm.cn/js/vue-2.6.10.min.js\"></script>\n          <script src=\"//cdn.hamm.cn/js/axios.min.js\"></script>\n          <script src=\"//cdn.hamm.cn/js/element.js\"></script>\n          <script src=\"//cdn.hamm.cn/js/vue-clipboard.min.js\"></script>\n          <script>\n          const json =\n" + json + "           </script>\n           <script>\n           new Vue({\n               el: '#app',\n               data() {\n                   return {\n                       url: window.location.pathname,\n                       api: json,\n                   }\n               },\n               created() {\n                   console.log(this.api)\n               },\n               updated() {},\n               methods: {}\n           });\n           </script>\n\n       </html>\n";
            try {
                response.reset();
                response.setCharacterEncoding("UTF-8");
                response.getWriter().write(html);
                response.flushBuffer();
            }
            catch (IOException exception) {
                log.error("\u8f93\u51fa\u6587\u6863\u5931\u8d25", (Throwable)exception);
            }
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getDocument() {
        return this.document;
    }

    public List<ApiRequestParam> getRequestParamList() {
        return this.requestParamList;
    }

    public ApiDocument setTitle(String title) {
        this.title = title;
        return this;
    }

    public ApiDocument setDocument(String document) {
        this.document = document;
        return this;
    }

    public ApiDocument setRequestParamList(List<ApiRequestParam> requestParamList) {
        this.requestParamList = requestParamList;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiDocument)) {
            return false;
        }
        ApiDocument other = (ApiDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$document = this.getDocument();
        String other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        List<ApiRequestParam> this$requestParamList = this.getRequestParamList();
        List<ApiRequestParam> other$requestParamList = other.getRequestParamList();
        return !(this$requestParamList == null ? other$requestParamList != null : !((Object)this$requestParamList).equals(other$requestParamList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        List<ApiRequestParam> $requestParamList = this.getRequestParamList();
        result = result * 59 + ($requestParamList == null ? 43 : ((Object)$requestParamList).hashCode());
        return result;
    }

    public String toString() {
        return "ApiDocument(title=" + this.getTitle() + ", document=" + this.getDocument() + ", requestParamList=" + this.getRequestParamList() + ")";
    }

    static class ApiRequestParam {
        private String name;
        private String type;
        private String link;
        private String description;
        private String document;
        private Boolean required = false;
        private List<Map<String, String>> dictionary = new ArrayList<Map<String, String>>();
        private List<ApiRequestParam> children = new ArrayList<ApiRequestParam>();
        private Boolean phone = false;
        private Boolean email = false;
        private Integer maxLength = 0;

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getLink() {
            return this.link;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDocument() {
            return this.document;
        }

        public Boolean getRequired() {
            return this.required;
        }

        public List<Map<String, String>> getDictionary() {
            return this.dictionary;
        }

        public List<ApiRequestParam> getChildren() {
            return this.children;
        }

        public Boolean getPhone() {
            return this.phone;
        }

        public Boolean getEmail() {
            return this.email;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public ApiRequestParam setName(String name) {
            this.name = name;
            return this;
        }

        public ApiRequestParam setType(String type) {
            this.type = type;
            return this;
        }

        public ApiRequestParam setLink(String link) {
            this.link = link;
            return this;
        }

        public ApiRequestParam setDescription(String description) {
            this.description = description;
            return this;
        }

        public ApiRequestParam setDocument(String document) {
            this.document = document;
            return this;
        }

        public ApiRequestParam setRequired(Boolean required) {
            this.required = required;
            return this;
        }

        public ApiRequestParam setDictionary(List<Map<String, String>> dictionary) {
            this.dictionary = dictionary;
            return this;
        }

        public ApiRequestParam setChildren(List<ApiRequestParam> children) {
            this.children = children;
            return this;
        }

        public ApiRequestParam setPhone(Boolean phone) {
            this.phone = phone;
            return this;
        }

        public ApiRequestParam setEmail(Boolean email) {
            this.email = email;
            return this;
        }

        public ApiRequestParam setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiRequestParam)) {
                return false;
            }
            ApiRequestParam other = (ApiRequestParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$required = this.getRequired();
            Boolean other$required = other.getRequired();
            if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
                return false;
            }
            Boolean this$phone = this.getPhone();
            Boolean other$phone = other.getPhone();
            if (this$phone == null ? other$phone != null : !((Object)this$phone).equals(other$phone)) {
                return false;
            }
            Boolean this$email = this.getEmail();
            Boolean other$email = other.getEmail();
            if (this$email == null ? other$email != null : !((Object)this$email).equals(other$email)) {
                return false;
            }
            Integer this$maxLength = this.getMaxLength();
            Integer other$maxLength = other.getMaxLength();
            if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$link = this.getLink();
            String other$link = other.getLink();
            if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$document = this.getDocument();
            String other$document = other.getDocument();
            if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
                return false;
            }
            List<Map<String, String>> this$dictionary = this.getDictionary();
            List<Map<String, String>> other$dictionary = other.getDictionary();
            if (this$dictionary == null ? other$dictionary != null : !((Object)this$dictionary).equals(other$dictionary)) {
                return false;
            }
            List<ApiRequestParam> this$children = this.getChildren();
            List<ApiRequestParam> other$children = other.getChildren();
            return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApiRequestParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $required = this.getRequired();
            result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
            Boolean $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : ((Object)$phone).hashCode());
            Boolean $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : ((Object)$email).hashCode());
            Integer $maxLength = this.getMaxLength();
            result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : $link.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $document = this.getDocument();
            result = result * 59 + ($document == null ? 43 : $document.hashCode());
            List<Map<String, String>> $dictionary = this.getDictionary();
            result = result * 59 + ($dictionary == null ? 43 : ((Object)$dictionary).hashCode());
            List<ApiRequestParam> $children = this.getChildren();
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            return result;
        }

        public String toString() {
            return "ApiDocument.ApiRequestParam(name=" + this.getName() + ", type=" + this.getType() + ", link=" + this.getLink() + ", description=" + this.getDescription() + ", document=" + this.getDocument() + ", required=" + this.getRequired() + ", dictionary=" + this.getDictionary() + ", children=" + this.getChildren() + ", phone=" + this.getPhone() + ", email=" + this.getEmail() + ", maxLength=" + this.getMaxLength() + ")";
        }
    }
}

