/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.interceptor;

import cn.hamm.airpower.config.GlobalConfig;
import cn.hamm.airpower.interceptor.document.ApiDocument;
import cn.hamm.airpower.request.RequestUtil;
import cn.hamm.airpower.result.Result;
import cn.hamm.airpower.security.AccessConfig;
import cn.hamm.airpower.security.AccessUtil;
import cn.hamm.airpower.security.SecurityUtil;
import cn.hamm.airpower.util.ReflectUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.lang.reflect.Method;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public abstract class AbstractRequestInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractRequestInterceptor.class);
    @Autowired
    private SecurityUtil securityUtil;
    @Autowired
    private GlobalConfig globalConfig;

    public final boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object object) {
        GetMapping getMapping;
        HandlerMethod handlerMethod = (HandlerMethod)object;
        Class clazz = handlerMethod.getBeanType();
        Method method = handlerMethod.getMethod();
        if (HttpMethod.GET.name().equalsIgnoreCase(request.getMethod()) && this.globalConfig.isEnableDocument() && Objects.isNull(getMapping = ReflectUtil.getAnnotation(GetMapping.class, method))) {
            ApiDocument.writeApiDocument(response, clazz, method);
            return false;
        }
        this.beforeHandleRequest(request, response, clazz, method);
        AccessConfig accessConfig = AccessUtil.getWhatNeedAccess(clazz, method);
        if (!accessConfig.login) {
            return true;
        }
        String accessToken = request.getHeader(this.globalConfig.getAuthorizeHeader());
        String accessTokenFromParam = request.getParameter(this.globalConfig.getAuthorizeHeader());
        if (StringUtils.hasText((String)accessTokenFromParam)) {
            accessToken = accessTokenFromParam;
        }
        Result.UNAUTHORIZED.whenEmpty(accessToken);
        Long userId = this.securityUtil.getUserIdFromAccessToken(accessToken);
        if (accessConfig.authorize) {
            return this.checkPermissionAccess(userId, AccessUtil.getPermissionIdentity(clazz, method), request);
        }
        return true;
    }

    public abstract boolean checkPermissionAccess(Long var1, String var2, HttpServletRequest var3);

    protected void beforeHandleRequest(HttpServletRequest request, HttpServletResponse response, Class<?> clazz, Method method) {
    }

    protected final void setShareData(String key, Object value) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (Objects.nonNull(requestAttributes)) {
            requestAttributes.setAttribute(key, value, 0);
        }
    }

    protected final String getRequestBody(HttpServletRequest request) {
        if (RequestUtil.isUploadRequest(request)) {
            return "";
        }
        try {
            String line;
            StringBuilder requestBody = new StringBuilder();
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                requestBody.append(line);
            }
            return requestBody.toString();
        }
        catch (Exception exception) {
            log.error("\u83b7\u53d6\u8bf7\u6c42\u5305\u4f53\u5931\u8d25", (Throwable)exception);
            return "";
        }
    }
}

