/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.exception;

import cn.hamm.airpower.config.GlobalConfig;
import cn.hamm.airpower.interceptor.document.ApiDocument;
import cn.hamm.airpower.result.Result;
import cn.hamm.airpower.result.ResultException;
import cn.hamm.airpower.result.json.Json;
import cn.hamm.airpower.result.json.JsonData;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
@ResponseStatus(value=HttpStatus.OK)
@ResponseBody
public class ExceptionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ExceptionInterceptor.class);
    @Autowired
    private GlobalConfig globalConfig;

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Json badRequestHandle(@NotNull MethodArgumentNotValidException exception) {
        log.error(exception.getMessage());
        BindingResult result = exception.getBindingResult();
        StringBuilder stringBuilder = new StringBuilder();
        if (!result.hasErrors()) {
            return new Json(Result.PARAM_INVALID);
        }
        if (!result.hasFieldErrors()) {
            return new Json(Result.PARAM_INVALID);
        }
        List errors = result.getFieldErrors();
        Iterator iterator = errors.iterator();
        if (iterator.hasNext()) {
            FieldError error = (FieldError)iterator.next();
            stringBuilder.append(error.getDefaultMessage()).append("(").append(error.getField()).append(")");
        }
        return new Json(Result.PARAM_INVALID, stringBuilder.toString());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Json badRequestHandle(@NotNull ConstraintViolationException exception) {
        log.error(exception.getMessage());
        StringBuilder stringBuilder = new StringBuilder();
        Set errors = exception.getConstraintViolations();
        Iterator iterator = errors.iterator();
        if (iterator.hasNext()) {
            ConstraintViolation error = (ConstraintViolation)iterator.next();
            stringBuilder.append(error.getMessage()).append("(").append(error.getInvalidValue()).append(")");
        }
        return new Json(Result.PARAM_INVALID, stringBuilder.toString());
    }

    @ExceptionHandler(value={SQLIntegrityConstraintViolationException.class, DataIntegrityViolationException.class})
    public Json deleteUsingDataException(@NotNull Exception exception) {
        log.error(exception.getMessage());
        if (this.globalConfig.isDebug()) {
            log.error("\u5220\u9664\u65f6\u7684\u6570\u636e\u5173\u8054\u6821\u9a8c\u5f02\u5e38", (Throwable)exception);
        }
        return new Json(Result.FORBIDDEN_DELETE_USED, "\u6570\u636e\u6b63\u5728\u4f7f\u7528\u4e2d,\u65e0\u6cd5\u88ab\u5220\u9664!");
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Json notFoundHandle(@NotNull NoHandlerFoundException exception, HttpServletResponse response) {
        String packageName;
        boolean result;
        String[] arr;
        log.error(exception.getMessage());
        if (this.globalConfig.isEnableDocument() && (arr = exception.getRequestURL().split("/")).length > 1 && !(result = ApiDocument.writeEntityDocument(packageName = arr[arr.length - 1], response))) {
            response.reset();
            return new Json(Result.API_SERVICE_UNSUPPORTED);
        }
        return new Json(Result.API_SERVICE_UNSUPPORTED);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Json dataExceptionHandle(@NotNull HttpMessageNotReadableException exception) {
        log.error(exception.getMessage());
        return new Json(Result.REQUEST_CONTENT_TYPE_UNSUPPORTED, "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\u662f\u5426\u63a5\u53e3\u652f\u6301\u7684JSON");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Json methodExceptionHandle(@NotNull HttpRequestMethodNotSupportedException exception) {
        log.error(exception.getMessage());
        String supportedMethod = String.join((CharSequence)"|", Objects.requireNonNull(exception.getSupportedMethods()));
        return new Json(Result.REQUEST_METHOD_UNSUPPORTED, exception.getMethod() + "\u4e0d\u88ab\u652f\u6301,\u8bf7\u4f7f\u7528" + supportedMethod + "\u65b9\u6cd5\u8bf7\u6c42");
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Json httpMediaTypeNotSupportedExceptionHandle(@NotNull HttpMediaTypeNotSupportedException exception) {
        log.error(exception.getMessage());
        if (this.globalConfig.isDebug()) {
            log.error("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b", (Throwable)exception);
        }
        return new Json(Result.REQUEST_CONTENT_TYPE_UNSUPPORTED, Objects.requireNonNull(exception.getContentType()) + "\u4e0d\u88ab\u652f\u6301,\u8bf7\u4f7f\u7528JSON\u8bf7\u6c42");
    }

    @ExceptionHandler(value={CannotCreateTransactionException.class})
    public Json databaseExceptionHandle(@NotNull CannotCreateTransactionException exception) {
        log.error(exception.getMessage());
        if (this.globalConfig.isDebug()) {
            log.error("\u6570\u636e\u5e93\u8fde\u63a5\u53d1\u751f\u9519\u8bef", (Throwable)exception);
        }
        return new Json(Result.DATABASE_ERROR);
    }

    @ExceptionHandler(value={RedisConnectionFailureException.class})
    public Json redisExceptionHandle(@NotNull RedisConnectionFailureException exception) {
        log.error(exception.getMessage());
        if (this.globalConfig.isDebug()) {
            log.error("REDIS\u8fde\u63a5\u53d1\u751f\u9519\u8bef", (Throwable)exception);
        }
        return new Json(Result.REDIS_ERROR);
    }

    @ExceptionHandler(value={ResultException.class})
    public JsonData customExceptionHandle(@NotNull ResultException exception) {
        log.error(exception.getMessage());
        if (this.globalConfig.isDebug()) {
            log.error("\u81ea\u5b9a\u4e49\u4e1a\u52a1\u5f02\u5e38", (Throwable)exception);
        }
        return new JsonData(exception.getData(), exception.getMessage(), exception.getCode());
    }

    @ExceptionHandler(value={PropertyReferenceException.class})
    public Json propertyReferenceExceptionHandle(@NotNull PropertyReferenceException exception) {
        log.error(exception.getMessage());
        if (this.globalConfig.isDebug()) {
            log.error("\u6570\u636e\u5b57\u6bb5\u4e0d\u5b58\u5728", (Throwable)exception);
        }
        return new Json(Result.DATABASE_UNKNOWN_FIELD, "\u4e0d\u652f\u6301\u7684\u6570\u636e\u5b57\u6bb5" + exception.getPropertyName());
    }

    @ExceptionHandler(value={InvalidDataAccessResourceUsageException.class})
    public Json invalidDataAccessResourceUsageExceptionHandle(@NotNull InvalidDataAccessResourceUsageException exception) {
        log.error(exception.getMessage());
        if (this.globalConfig.isDebug()) {
            log.error("\u6570\u636e\u8868\u6216\u5b57\u6bb5\u5f02\u5e38", (Throwable)exception);
        }
        return new Json(Result.DATABASE_TABLE_OR_FIELD_ERROR);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public Json maxUploadSizeExceededExceptionHandle(@NotNull MaxUploadSizeExceededException exception) {
        log.error(exception.getMessage());
        if (this.globalConfig.isDebug()) {
            log.error("\u4e0a\u4f20\u8d85\u8fc7\u6700\u5927\u9650\u5236", (Throwable)exception);
        }
        return new Json(Result.FORBIDDEN_UPLOAD_MAX_SIZE.getCode(), "\u4e0a\u4f20\u7684\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u6700\u5927\u9650\u5236");
    }

    @ExceptionHandler(value={Exception.class, RuntimeException.class})
    public Object otherExceptionHandle(@NotNull Exception exception) {
        log.error(exception.getMessage());
        if (this.globalConfig.isDebug()) {
            log.error("\u5176\u4ed6\u5f02\u5e38", (Throwable)exception);
        }
        return new Json(Result.ERROR);
    }
}

