/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util.redis;

import cn.hamm.airpower.config.GlobalConfig;
import cn.hamm.airpower.result.json.Json;
import cn.hamm.airpower.root.RootEntity;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil<E extends RootEntity<E>> {
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private GlobalConfig globalConfig;

    public final E getEntity(E entity) {
        Object object = this.get(this.getCacheKey(entity));
        if (Objects.isNull(object)) {
            return null;
        }
        String json = object.toString();
        if (Objects.isNull(json)) {
            return null;
        }
        return (E)((RootEntity)Json.parse(json, entity.getClass()));
    }

    public final E getEntity(String key, E entity) {
        Object object = this.get(key);
        if (Objects.isNull(object)) {
            return null;
        }
        String json = object.toString();
        if (Objects.isNull(json)) {
            return null;
        }
        return (E)((RootEntity)Json.parse(json, entity.getClass()));
    }

    public final void deleteEntity(E entity) {
        this.del(this.getCacheKey(entity));
    }

    public final void saveEntity(E entity) {
        this.saveEntity(entity, this.globalConfig.getCacheExpireSecond());
    }

    public final void saveEntity(E entity, long second) {
        this.set(this.getCacheKey(entity), Json.toString(entity), second);
    }

    public final void saveEntity(String key, E entity) {
        this.saveEntity(key, entity, this.globalConfig.getCacheExpireSecond());
    }

    public final void saveEntity(String key, E entity, long second) {
        this.set(key, Json.toString(entity), second);
    }

    public final void setExpireSecond(String key, long second) {
        try {
            if (second > 0L) {
                this.redisTemplate.expire((Object)key, second, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            throw new RedisConnectionFailureException("Redis\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
        }
    }

    public final void clearAll(String pattern) {
        try {
            Set keys = this.redisTemplate.keys((Object)pattern);
            if (Objects.nonNull(keys)) {
                this.redisTemplate.delete((Collection)keys);
            }
        }
        catch (Exception e) {
            throw new RedisConnectionFailureException("Redis\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
        }
    }

    public final long getExpireSecond(String key) {
        try {
            return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RedisConnectionFailureException("Redis\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
        }
    }

    public final boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public final void del(String key) {
        try {
            this.redisTemplate.delete((Object)key);
        }
        catch (Exception e) {
            throw new RedisConnectionFailureException("Redis\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
        }
    }

    public final Object get(String key) {
        try {
            return this.redisTemplate.opsForValue().get((Object)key);
        }
        catch (Exception e) {
            throw new RedisConnectionFailureException("Redis\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
        }
    }

    public final void set(String key, Object value) {
        this.set(key, value, this.globalConfig.getCacheExpireSecond());
    }

    public final void set(String key, Object value, long second) {
        try {
            if (second > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, second, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
        }
        catch (Exception e) {
            throw new RedisConnectionFailureException("Redis\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
        }
    }

    public final void publish(String channel, String message) {
        this.redisTemplate.convertAndSend(channel, (Object)message);
    }

    private String getCacheKey(E entity) {
        return entity.getClass().getSimpleName() + "_" + ((RootEntity)entity).getId().toString();
    }
}

