/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.root;

import cn.hamm.airpower.annotation.ReadOnly;
import cn.hamm.airpower.annotation.Search;
import cn.hamm.airpower.config.GlobalConfig;
import cn.hamm.airpower.model.Sort;
import cn.hamm.airpower.query.QueryPageRequest;
import cn.hamm.airpower.query.QueryPageResponse;
import cn.hamm.airpower.query.QueryRequest;
import cn.hamm.airpower.result.Result;
import cn.hamm.airpower.result.ResultException;
import cn.hamm.airpower.root.RootEntity;
import cn.hamm.airpower.root.RootRepository;
import cn.hamm.airpower.security.SecurityUtil;
import cn.hamm.airpower.util.ReflectUtil;
import cn.hamm.airpower.util.redis.RedisUtil;
import jakarta.persistence.Column;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.StringUtils;

public class RootService<E extends RootEntity<E>, R extends RootRepository<E>> {
    private static final Logger log = LoggerFactory.getLogger(RootService.class);
    @Autowired
    protected R repository;
    @Autowired
    private GlobalConfig globalConfig;
    @Autowired
    protected RedisUtil<E> redisUtil;
    @Autowired
    protected SecurityUtil secureUtil;
    @Autowired
    private EntityManager entityManager;

    protected E beforeAdd(E source) {
        return source;
    }

    public final long add(E source) {
        source = this.beforeAdd(source);
        ((RootEntity)((RootEntity)((RootEntity)source).setId(null)).setIsDisabled(false)).setCreateTime(System.currentTimeMillis());
        if (Objects.isNull(((RootEntity)source).getRemark())) {
            ((RootEntity)source).setRemark("");
        }
        long id = this.saveToDatabase(source);
        this.afterAdd(id, source);
        return id;
    }

    protected void afterAdd(long id, E source) {
    }

    protected E beforeUpdate(E source) {
        return source;
    }

    public final void update(E source) {
        Result.PARAM_MISSING.whenNull(((RootEntity)source).getId(), "\u4fee\u6539\u5931\u8d25, \u8bf7\u4f20\u5165" + ReflectUtil.getDescription(this.getEntityClass()) + "ID!");
        source = this.beforeUpdate(source);
        this.saveToDatabase(source);
        this.afterUpdate(((RootEntity)source).getId(), source);
        this.afterSaved(((RootEntity)source).getId(), source);
    }

    public final void updateWithNull(E source) {
        Result.PARAM_MISSING.whenNull(((RootEntity)source).getId(), "\u4fee\u6539\u5931\u8d25, \u8bf7\u4f20\u5165" + ReflectUtil.getDescription(this.getEntityClass()) + "ID!");
        source = this.beforeUpdate(source);
        this.saveToDatabase(source, true);
        this.afterUpdate(((RootEntity)source).getId(), source);
        this.afterSaved(((RootEntity)source).getId(), source);
    }

    protected void afterUpdate(long id, E source) {
    }

    protected void afterSaved(long id, E source) {
    }

    protected void beforeDisable(long id) {
    }

    public final void disable(long id) {
        this.beforeDisable(id);
        this.disableById(id);
        this.afterDisable(id);
    }

    protected void afterDisable(long id) {
    }

    protected void beforeEnable(long id) {
    }

    public final void enable(long id) {
        this.beforeEnable(id);
        this.enableById(id);
        this.afterEnable(id);
    }

    protected void afterEnable(long id) {
    }

    protected void beforeDelete(long id) {
    }

    public final void delete(long id) {
        this.beforeDelete(id);
        this.deleteById(id);
        this.afterDelete(id);
    }

    protected void afterDelete(long id) {
    }

    protected <T extends QueryRequest<E>> T beforeGetList(T sourceRequestData) {
        return sourceRequestData;
    }

    public final List<E> getList(QueryRequest<E> queryRequest) {
        if (Objects.isNull(queryRequest)) {
            queryRequest = new QueryRequest();
        }
        if (Objects.isNull(queryRequest.getFilter())) {
            queryRequest.setFilter(this.getNewInstance());
        }
        queryRequest = this.beforeGetList(queryRequest);
        List list = this.repository.findAll(this.createSpecification((RootEntity)queryRequest.getFilter(), false), this.createSort(queryRequest.getSort()));
        return this.afterGetList(list);
    }

    public final List<E> filter(E filter) {
        QueryRequest<E> queryRequest = new QueryRequest<E>();
        if (Objects.isNull(queryRequest.getFilter())) {
            queryRequest.setFilter(filter);
        }
        return this.repository.findAll(this.createSpecification(filter, true), this.createSort(queryRequest.getSort()));
    }

    protected List<E> afterGetList(List<E> list) {
        return list;
    }

    protected <T extends QueryPageRequest<E>> T beforeGetPage(T sourceRequestData) {
        return sourceRequestData;
    }

    protected QueryPageResponse<E> afterGetPage(QueryPageResponse<E> queryPageResponse) {
        return queryPageResponse;
    }

    protected E beforeSaveToDatabase(E entity) {
        return entity;
    }

    protected List<Predicate> addSearchPredicate(Root<E> root, CriteriaBuilder builder, E search) {
        return new ArrayList<Predicate>();
    }

    public final E get(long id) {
        return this.afterGet(this.getById(id));
    }

    public final E getMaybeNull(long id) {
        return this.afterGet(this.getByIdMaybeNull(id));
    }

    protected E afterGet(E result) {
        return result;
    }

    public final QueryPageResponse<E> getPage(QueryPageRequest<E> queryPageRequest) {
        if (Objects.isNull(queryPageRequest)) {
            queryPageRequest = new QueryPageRequest();
        }
        if (Objects.isNull(queryPageRequest.getFilter())) {
            queryPageRequest.setFilter(this.getNewInstance());
        }
        queryPageRequest = this.beforeGetPage(queryPageRequest);
        Page pageData = this.repository.findAll(this.createSpecification((RootEntity)queryPageRequest.getFilter(), false), this.createPageable(queryPageRequest));
        QueryPageResponse<E> queryPageResponse = this.getResponsePageList(pageData);
        queryPageResponse.setSort(queryPageRequest.getSort());
        return this.afterGetPage(queryPageResponse);
    }

    protected final void disableById(long id) {
        E entity = this.get(id);
        this.saveToDatabase(((RootEntity)entity).setIsDisabled(true));
    }

    protected final void enableById(long id) {
        E entity = this.get(id);
        this.saveToDatabase(((RootEntity)entity).setIsDisabled(false));
    }

    protected final void deleteById(long id) {
        this.repository.deleteById((Object)id);
    }

    protected final E ignoreReadOnlyFields(E entity) {
        List<Field> fields = ReflectUtil.getFieldList(this.getEntityClass());
        for (Field field : fields) {
            ReadOnly annotation = field.getAnnotation(ReadOnly.class);
            if (Objects.isNull(annotation)) continue;
            try {
                field.setAccessible(true);
                field.set(entity, null);
            }
            catch (Exception e) {
                Result.ERROR.show();
            }
        }
        return entity;
    }

    private E getById(long id) {
        Result.PARAM_MISSING.whenNull(id, "\u67e5\u8be2\u5931\u8d25, \u8bf7\u4f20\u5165" + ReflectUtil.getDescription(this.getEntityClass()) + "ID!");
        Optional optional = this.repository.findById((Object)id);
        if (optional.isPresent()) {
            return (E)((RootEntity)optional.get());
        }
        Result.DATA_NOT_FOUND.show("\u6ca1\u6709\u67e5\u5230ID\u4e3a" + id + "\u7684" + ReflectUtil.getDescription(this.getEntityClass()) + "!");
        return this.getNewInstance();
    }

    private E getByIdMaybeNull(long id) {
        try {
            return this.get(id);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private long saveToDatabase(E entity) {
        return this.saveToDatabase(entity, false);
    }

    private long saveToDatabase(E entity, boolean withNull) {
        this.checkUnique(entity);
        ((RootEntity)entity).setUpdateTime(System.currentTimeMillis());
        if (Objects.nonNull(((RootEntity)entity).getId())) {
            this.entityManager.clear();
            E existEntity = this.getById(((RootEntity)entity).getId());
            if (Objects.isNull(((RootEntity)existEntity).getRemark()) && Objects.isNull(((RootEntity)entity).getRemark())) {
                ((RootEntity)entity).setRemark("");
            }
            if (!withNull) {
                entity = this.getEntityForSave(entity, existEntity);
            }
        }
        Object target = this.getNewInstance();
        BeanUtils.copyProperties(entity, target);
        target = this.beforeSaveToDatabase(target);
        target = (RootEntity)this.repository.saveAndFlush(target);
        this.entityManager.clear();
        return ((RootEntity)target).getId();
    }

    private E getEntityForSave(E sourceEntity, E existEntity) {
        String[] nullProperties = this.getNullProperties(sourceEntity);
        BeanUtils.copyProperties(sourceEntity, existEntity, (String[])nullProperties);
        return existEntity;
    }

    private void checkUnique(E entity) {
        List<Field> fields = ReflectUtil.getFieldList(this.getEntityClass());
        for (Field field : fields) {
            String fieldName = ReflectUtil.getDescription(field);
            Column annotation = field.getAnnotation(Column.class);
            if (Objects.isNull(annotation) || !annotation.unique()) continue;
            Object fieldValue = "";
            try {
                field.setAccessible(true);
                fieldValue = field.get(entity);
                if (Objects.isNull(fieldValue)) continue;
                E search = this.getNewInstance();
                field.set(search, fieldValue);
                Example example = Example.of(search);
                Optional exist = this.repository.findOne(example);
                if (exist.isEmpty() || Objects.nonNull(((RootEntity)entity).getId()) && ((RootEntity)exist.get()).getId().equals(((RootEntity)entity).getId())) {
                    continue;
                }
            }
            catch (Exception e) {
                Result.ERROR.show();
            }
            Result.FORBIDDEN_EXIST.show(fieldName + "(" + fieldValue.toString() + ")\u5df2\u7ecf\u5b58\u5728\uff01");
        }
    }

    private E getNewInstance() {
        try {
            return (E)((RootEntity)this.getEntityClass().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new ResultException("\u521d\u59cb\u5316\u5b9e\u4f53\u5931\u8d25");
        }
    }

    private Class<E> getEntityClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    private String[] getNullProperties(E sourceEntity) {
        BeanWrapperImpl srcBean = new BeanWrapperImpl(sourceEntity);
        PropertyDescriptor[] propertyDescriptors = srcBean.getPropertyDescriptors();
        HashSet<String> properties = new HashSet<String>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            String propertyName = propertyDescriptor.getName();
            Object propertyValue = srcBean.getPropertyValue(propertyName);
            if (!Objects.isNull(propertyValue)) continue;
            properties.add(propertyName);
        }
        return properties.toArray(new String[0]);
    }

    private QueryPageResponse<E> getResponsePageList(Page<E> data) {
        return new QueryPageResponse().setList(data.getContent()).setTotal(Math.toIntExact(data.getTotalElements())).setPageCount(data.getTotalPages()).setPage(new cn.hamm.airpower.model.Page().setPageSize(data.getPageable().getPageSize()).setPageNum(data.getPageable().getPageNumber() + 1));
    }

    private org.springframework.data.domain.Sort createSort(Sort sort) {
        if (Objects.isNull(sort)) {
            sort = new Sort();
        }
        if (!StringUtils.hasText((String)sort.getField())) {
            sort.setField(this.globalConfig.getDefaultSortField());
        }
        if (!StringUtils.hasText((String)sort.getDirection())) {
            sort.setDirection(this.globalConfig.getDefaultSortDirection());
        }
        if (!this.globalConfig.getDefaultSortDirection().equals(sort.getDirection())) {
            return org.springframework.data.domain.Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)sort.getField())});
        }
        return org.springframework.data.domain.Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)sort.getField())});
    }

    private Pageable createPageable(QueryPageRequest<E> queryPageData) {
        cn.hamm.airpower.model.Page page = queryPageData.getPage();
        if (Objects.isNull(page)) {
            page = new cn.hamm.airpower.model.Page();
        }
        if (Objects.isNull(page.getPageNum())) {
            page.setPageNum(1);
        }
        if (Objects.isNull(page.getPageSize())) {
            page.setPageSize(this.globalConfig.getDefaultPageSize());
        }
        int pageNumber = page.getPageNum() - 1;
        pageNumber = Math.max(0, pageNumber);
        int pageSize = queryPageData.getPage().getPageSize();
        pageSize = Math.max(1, pageSize);
        return PageRequest.of((int)pageNumber, (int)pageSize, (org.springframework.data.domain.Sort)this.createSort(queryPageData.getSort()));
    }

    private List<Predicate> getPredicateList(Object root, CriteriaBuilder builder, Object search, boolean isRoot, boolean isEqual) {
        ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
        List<Field> fields = ReflectUtil.getFieldList(search.getClass());
        for (Field field : fields) {
            try {
                Predicate predicate;
                Search searchMode;
                field.setAccessible(true);
                Object fieldValue = field.get(search);
                if (Objects.isNull(fieldValue) || !StringUtils.hasText((String)fieldValue.toString()) || Objects.isNull(searchMode = field.getAnnotation(Search.class))) continue;
                if (searchMode.value() == Search.Mode.JOIN) {
                    Join payload;
                    if (isRoot) {
                        payload = ((Root)root).join(field.getName(), JoinType.INNER);
                        predicateList.addAll(this.getPredicateList(payload, builder, fieldValue, false, isEqual));
                        continue;
                    }
                    payload = ((Join)root).join(field.getName(), JoinType.INNER);
                    predicateList.addAll(this.getPredicateList(payload, builder, fieldValue, false, isEqual));
                    continue;
                }
                Object searchValue = fieldValue.toString();
                if (Boolean.class.equals(fieldValue.getClass())) {
                    predicate = isRoot ? builder.equal((Expression)((Root)root).get(field.getName()), fieldValue) : builder.equal((Expression)((Join)root).get(field.getName()), fieldValue);
                    predicateList.add(predicate);
                    continue;
                }
                if (Search.Mode.LIKE.equals((Object)searchMode.value()) && !isEqual) {
                    searchValue = (String)searchValue + "%";
                    predicate = isRoot ? builder.like((Expression)((Root)root).get(field.getName()), (String)searchValue) : builder.like((Expression)((Join)root).get(field.getName()), (String)searchValue);
                    predicateList.add(predicate);
                    continue;
                }
                predicate = isRoot ? builder.equal((Expression)((Root)root).get(field.getName()), fieldValue) : builder.equal((Expression)((Join)root).get(field.getName()), fieldValue);
                predicateList.add(predicate);
            }
            catch (IllegalAccessException exception) {
                log.error(exception.getMessage());
            }
        }
        return predicateList;
    }

    private void addCreateAndUpdateTimePredicate(Root<E> root, CriteriaBuilder builder, E search, List<Predicate> predicateList) {
        if (Objects.nonNull(((RootEntity)search).getCreateTimeFrom())) {
            predicateList.add(builder.greaterThanOrEqualTo((Expression)root.get("createTime"), (Comparable)((RootEntity)search).getCreateTimeFrom()));
        }
        if (Objects.nonNull(((RootEntity)search).getCreateTimeTo())) {
            predicateList.add(builder.lessThan((Expression)root.get("createTime"), (Comparable)((RootEntity)search).getCreateTimeTo()));
        }
        if (Objects.nonNull(((RootEntity)search).getUpdateTimeFrom())) {
            predicateList.add(builder.greaterThanOrEqualTo((Expression)root.get("updateTime"), (Comparable)((RootEntity)search).getUpdateTimeFrom()));
        }
        if (Objects.nonNull(((RootEntity)search).getUpdateTimeTo())) {
            predicateList.add(builder.lessThan((Expression)root.get("updateTime"), (Comparable)((RootEntity)search).getUpdateTimeTo()));
        }
    }

    private Specification<E> createSpecification(E filter, boolean isEqual) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> this.createPredicate(root, criteriaQuery, criteriaBuilder, filter, isEqual);
    }

    private Predicate createPredicate(Root<E> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder builder, E filter, boolean isEqual) {
        List<Predicate> predicateList = this.getPredicateList(root, builder, filter, true, isEqual);
        predicateList.addAll(this.addSearchPredicate(root, builder, filter));
        this.addCreateAndUpdateTimePredicate(root, builder, filter, predicateList);
        Predicate[] predicates = new Predicate[predicateList.size()];
        criteriaQuery.where((Expression)builder.and(predicateList.toArray(predicates)));
        return criteriaQuery.getRestriction();
    }
}

