/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.root;

import cn.hamm.airpower.annotation.Exclude;
import cn.hamm.airpower.annotation.Expose;
import cn.hamm.airpower.annotation.Payload;
import cn.hamm.airpower.interfaces.IAction;
import cn.hamm.airpower.result.Result;
import cn.hamm.airpower.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.BeanUtils;

public class RootModel<M extends RootModel<M>>
implements IAction {
    public final <T> T copyTo(Class<T> clazz) {
        try {
            T target = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            BeanUtils.copyProperties((Object)this, target);
            return target;
        }
        catch (Exception e) {
            Result.ERROR.show(e.getMessage());
            return null;
        }
    }

    public final M exclude(String ... fieldNames) {
        ArrayList<String> list = new ArrayList<String>(fieldNames.length);
        Collections.addAll(list, fieldNames);
        return this.exclude(list);
    }

    public final M exclude(List<String> fieldNames) {
        List<Field> fieldList = ReflectUtil.getFieldList(this.getClass());
        block0: for (Field field : fieldList) {
            for (String fieldName : fieldNames) {
                if (!field.getName().equals(fieldName)) continue;
                this.clearField(field);
                continue block0;
            }
        }
        return (M)this;
    }

    public final M expose(String ... fieldNames) {
        List<Field> fieldList = ReflectUtil.getFieldList(this.getClass());
        for (Field field : fieldList) {
            boolean needReturn = false;
            for (String fieldName : fieldNames) {
                if (!field.getName().equals(fieldName)) continue;
                needReturn = true;
                break;
            }
            if (needReturn) continue;
            this.clearField(field);
        }
        return (M)this;
    }

    public final M filterResponseDataBy(Class<?> filter) {
        Class<?> clazz = this.getClass();
        List<Field> allFields = ReflectUtil.getFieldList(clazz);
        Exclude exclude = clazz.getAnnotation(Exclude.class);
        if (Objects.nonNull(exclude)) {
            for (Field field : allFields) {
                this.exposeBy(filter, field);
            }
            return (M)this;
        }
        for (Field field : allFields) {
            this.excludeBy(filter, field);
        }
        return (M)this;
    }

    private void excludeBy(Class<?> filter, Field field) {
        Exclude fieldExclude = field.getAnnotation(Exclude.class);
        if (Objects.isNull(fieldExclude)) {
            this.filterFieldPayload(field);
            return;
        }
        boolean isExclude = false;
        Class<?>[] excludeClasses = fieldExclude.filters();
        if (excludeClasses.length == 0) {
            isExclude = true;
        } else {
            for (Class<?> excludeClass : excludeClasses) {
                if (Void.class.equals(filter) || !filter.equals(excludeClass)) continue;
                isExclude = true;
                break;
            }
        }
        if (isExclude) {
            this.clearField(field);
        }
        this.filterFieldPayload(field);
    }

    private void exposeBy(Class<?> filter, Field field) {
        Expose fieldExpose = field.getAnnotation(Expose.class);
        if (Objects.isNull(fieldExpose)) {
            this.clearField(field);
            this.filterFieldPayload(field);
            return;
        }
        boolean isExpose = false;
        Class<?>[] exposeClasses = fieldExpose.filters();
        if (exposeClasses.length > 0) {
            for (Class<?> exposeClass : exposeClasses) {
                if (!Void.class.equals(filter) && !filter.equals(exposeClass)) continue;
                isExpose = true;
                break;
            }
        } else {
            isExpose = true;
        }
        if (!isExpose) {
            this.clearField(field);
        }
        this.filterFieldPayload(field);
    }

    private void filterFieldPayload(Field field) {
        Payload payload = field.getAnnotation(Payload.class);
        if (Objects.isNull(payload)) {
            return;
        }
        try {
            field.setAccessible(true);
            Object fieldValue = field.get(this);
            Class<?> fieldClass = field.getType();
            if (fieldClass.isArray()) {
                RootModel[] list;
                for (RootModel item2 : list = (RootModel[])fieldValue) {
                    field.set(this, item2.filterResponseDataBy(IAction.WhenPayLoad.class));
                }
                return;
            }
            if (Set.class.equals(fieldClass)) {
                HashSet list = (HashSet)fieldValue;
                if (Objects.isNull(list)) {
                    list = new HashSet();
                }
                list.forEach(item -> item.filterResponseDataBy(IAction.WhenPayLoad.class));
                field.set(this, list);
                return;
            }
            if (Objects.nonNull(fieldValue)) {
                field.set(this, ((RootModel)fieldValue).filterResponseDataBy(IAction.WhenPayLoad.class));
            }
        }
        catch (ClassCastException | IllegalAccessException exception) {
            // empty catch block
        }
    }

    private void clearField(Field field) {
        try {
            field.setAccessible(true);
            field.set(this, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }
}

