/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.request;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidateUtil {
    public static final Pattern NUMBER = Pattern.compile("^(-?\\d+)(\\.\\d+)?$");
    public static final Pattern LETTER = Pattern.compile("^[A-Za-z]+$");
    public static final Pattern INTEGER = Pattern.compile("^-?[0-9]\\d*$");
    public static final Pattern EMAIL = Pattern.compile("^[a-zA-Z0-9]+(\\.([a-zA-Z0-9]+))*@[a-zA-Z0-9]+(\\.([a-zA-Z0-9]+))+$");
    public static final Pattern LETTER_OR_NUMBER = Pattern.compile("^[A-Za-z0-9]+$");
    public static final Pattern CHINESE = Pattern.compile("^[\\u4e00-\\u9fa5]*$");
    public static final Pattern MOBILE_PHONE = Pattern.compile("^(\\+(\\d{1,4}))?1[3-9](\\d{9})$");
    public static final Pattern TEL_PHONE = Pattern.compile("^(((0\\d{2,3})-)?((\\d{7,8})|(400\\d{7})|(800\\d{7}))(-(\\d{1,4}))?)$");
    public static final Pattern NORMAL_CODE = Pattern.compile("^[@#%a-zA-Z0-9\\u4e00-\\u9fa5_\\-\\\\/+]+$");
    public static final Pattern NUMBER_OR_LETTER = Pattern.compile("^[0-9a-zA-Z]+$");
    public static final Pattern NATURAL_NUMBER = Pattern.compile("^[0-9]+((.)[0-9]+)?$");
    public static final Pattern NATURAL_INTEGER = Pattern.compile("^[0-9]+$");

    public static boolean isNumber(String value) {
        return ValidateUtil.validRegex(value, NUMBER);
    }

    public static boolean isInteger(String value) {
        return ValidateUtil.validRegex(value, INTEGER);
    }

    public static boolean isEmail(String value) {
        return ValidateUtil.validRegex(value, EMAIL);
    }

    public static boolean isLetter(String value) {
        return ValidateUtil.validRegex(value, LETTER);
    }

    public static boolean isLetterOrNumber(String value) {
        return ValidateUtil.validRegex(value, LETTER_OR_NUMBER);
    }

    public static boolean isChinese(String value) {
        return ValidateUtil.validRegex(value, CHINESE);
    }

    public static boolean isMobilePhone(String value) {
        return ValidateUtil.validRegex(value, MOBILE_PHONE);
    }

    public static boolean isTelPhone(String value) {
        return ValidateUtil.validRegex(value, TEL_PHONE);
    }

    public static boolean isNormalCode(String value) {
        return ValidateUtil.validRegex(value, NORMAL_CODE);
    }

    public static boolean isOnlyNumberAndLetter(String value) {
        return ValidateUtil.validRegex(value, NUMBER_OR_LETTER);
    }

    public static boolean isNaturalNumber(String value) {
        return ValidateUtil.validRegex(value, NATURAL_NUMBER);
    }

    public static boolean isNaturalInteger(String value) {
        return ValidateUtil.validRegex(value, NATURAL_INTEGER);
    }

    public static boolean validRegex(String value, Pattern pattern) {
        Matcher emailMatcher = pattern.matcher(value);
        return emailMatcher.matches();
    }
}

