/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.request;

import cn.hamm.airpower.result.Result;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;

public class RequestUtil {
    private static final String MULTI_IP_ADDRESS_SPLITTER = ",";
    private static final int MAX_IP_ADDRESS_CHAR_LENGTH = 15;
    private static final String ERROR_MESSAGE = "\u4f60\u7684IP\u5730\u5740\u5f02\u5e38";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";

    public static boolean isUploadRequest(HttpServletRequest request) {
        return RequestUtil.isUploadFileContentType(request.getContentType());
    }

    public static boolean isUploadRequest(ServletRequest request) {
        return RequestUtil.isUploadFileContentType(request.getContentType());
    }

    private static boolean isUploadFileContentType(String contentType) {
        return contentType != null && contentType.startsWith(MULTIPART_FORM_DATA);
    }

    public static String getIpAddress(HttpServletRequest request) {
        try {
            String ipAddress = request.getHeader("x-forwarded-for");
            if (RequestUtil.isValidAddress(ipAddress)) {
                return ipAddress;
            }
            ipAddress = request.getHeader("Proxy-Client-IP");
            if (RequestUtil.isValidAddress(ipAddress)) {
                return ipAddress;
            }
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
            if (RequestUtil.isValidAddress(ipAddress)) {
                return ipAddress;
            }
            ipAddress = request.getRemoteAddr();
            if ("127.0.0.1".equals(ipAddress)) {
                try {
                    InetAddress inet = InetAddress.getLocalHost();
                    ipAddress = inet.getHostAddress();
                    if (RequestUtil.isValidAddress(ipAddress)) {
                        return ipAddress;
                    }
                }
                catch (UnknownHostException e) {
                    Result.FORBIDDEN.show(ERROR_MESSAGE);
                }
            }
            return "127.0.0.1";
        }
        catch (Exception e) {
            Result.FORBIDDEN.show(ERROR_MESSAGE);
            return "";
        }
    }

    private static boolean isValidAddress(String ipAddress) {
        return Objects.nonNull(ipAddress) && !ipAddress.isEmpty() && !"127.0.0.1".equalsIgnoreCase(ipAddress);
    }

    private static String getRealIpAddress(String ipAddress) {
        if (Objects.nonNull(ipAddress) && ipAddress.length() > 15 && ipAddress.indexOf(MULTI_IP_ADDRESS_SPLITTER) > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(MULTI_IP_ADDRESS_SPLITTER));
        }
        return ipAddress;
    }
}

