/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.config;

import cn.hamm.airpower.config.CookieConfig;
import cn.hamm.airpower.config.MqttConfig;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConfigurationProperties(value="airpower")
public class GlobalConfig {
    private boolean enableDocument = false;
    private int defaultPageSize = 20;
    public static String databasePrefix = "tenant_";
    private boolean isServiceRunning = true;
    private boolean cache = false;
    private int cacheExpireSecond = 60;
    private String defaultSortField = "createTime";
    private String defaultSortDirection = "desc";
    private String authorizeHeader = "authorization";
    private int authorizeExpireTime = 86400;
    private String tenantHeader = "tenant-code";
    private boolean debug = true;
    private MqttConfig mqtt = new MqttConfig();
    private CookieConfig cookie = new CookieConfig();

    public boolean isEnableDocument() {
        return this.enableDocument;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public boolean isServiceRunning() {
        return this.isServiceRunning;
    }

    public boolean isCache() {
        return this.cache;
    }

    public int getCacheExpireSecond() {
        return this.cacheExpireSecond;
    }

    public String getDefaultSortField() {
        return this.defaultSortField;
    }

    public String getDefaultSortDirection() {
        return this.defaultSortDirection;
    }

    public String getAuthorizeHeader() {
        return this.authorizeHeader;
    }

    public int getAuthorizeExpireTime() {
        return this.authorizeExpireTime;
    }

    public String getTenantHeader() {
        return this.tenantHeader;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public MqttConfig getMqtt() {
        return this.mqtt;
    }

    public CookieConfig getCookie() {
        return this.cookie;
    }

    public GlobalConfig setEnableDocument(boolean enableDocument) {
        this.enableDocument = enableDocument;
        return this;
    }

    public GlobalConfig setDefaultPageSize(int defaultPageSize) {
        this.defaultPageSize = defaultPageSize;
        return this;
    }

    public GlobalConfig setServiceRunning(boolean isServiceRunning) {
        this.isServiceRunning = isServiceRunning;
        return this;
    }

    public GlobalConfig setCache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public GlobalConfig setCacheExpireSecond(int cacheExpireSecond) {
        this.cacheExpireSecond = cacheExpireSecond;
        return this;
    }

    public GlobalConfig setDefaultSortField(String defaultSortField) {
        this.defaultSortField = defaultSortField;
        return this;
    }

    public GlobalConfig setDefaultSortDirection(String defaultSortDirection) {
        this.defaultSortDirection = defaultSortDirection;
        return this;
    }

    public GlobalConfig setAuthorizeHeader(String authorizeHeader) {
        this.authorizeHeader = authorizeHeader;
        return this;
    }

    public GlobalConfig setAuthorizeExpireTime(int authorizeExpireTime) {
        this.authorizeExpireTime = authorizeExpireTime;
        return this;
    }

    public GlobalConfig setTenantHeader(String tenantHeader) {
        this.tenantHeader = tenantHeader;
        return this;
    }

    public GlobalConfig setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public GlobalConfig setMqtt(MqttConfig mqtt) {
        this.mqtt = mqtt;
        return this;
    }

    public GlobalConfig setCookie(CookieConfig cookie) {
        this.cookie = cookie;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalConfig)) {
            return false;
        }
        GlobalConfig other = (GlobalConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableDocument() != other.isEnableDocument()) {
            return false;
        }
        if (this.getDefaultPageSize() != other.getDefaultPageSize()) {
            return false;
        }
        if (this.isServiceRunning() != other.isServiceRunning()) {
            return false;
        }
        if (this.isCache() != other.isCache()) {
            return false;
        }
        if (this.getCacheExpireSecond() != other.getCacheExpireSecond()) {
            return false;
        }
        if (this.getAuthorizeExpireTime() != other.getAuthorizeExpireTime()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        String this$defaultSortField = this.getDefaultSortField();
        String other$defaultSortField = other.getDefaultSortField();
        if (this$defaultSortField == null ? other$defaultSortField != null : !this$defaultSortField.equals(other$defaultSortField)) {
            return false;
        }
        String this$defaultSortDirection = this.getDefaultSortDirection();
        String other$defaultSortDirection = other.getDefaultSortDirection();
        if (this$defaultSortDirection == null ? other$defaultSortDirection != null : !this$defaultSortDirection.equals(other$defaultSortDirection)) {
            return false;
        }
        String this$authorizeHeader = this.getAuthorizeHeader();
        String other$authorizeHeader = other.getAuthorizeHeader();
        if (this$authorizeHeader == null ? other$authorizeHeader != null : !this$authorizeHeader.equals(other$authorizeHeader)) {
            return false;
        }
        String this$tenantHeader = this.getTenantHeader();
        String other$tenantHeader = other.getTenantHeader();
        if (this$tenantHeader == null ? other$tenantHeader != null : !this$tenantHeader.equals(other$tenantHeader)) {
            return false;
        }
        MqttConfig this$mqtt = this.getMqtt();
        MqttConfig other$mqtt = other.getMqtt();
        if (this$mqtt == null ? other$mqtt != null : !((Object)this$mqtt).equals(other$mqtt)) {
            return false;
        }
        CookieConfig this$cookie = this.getCookie();
        CookieConfig other$cookie = other.getCookie();
        return !(this$cookie == null ? other$cookie != null : !((Object)this$cookie).equals(other$cookie));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableDocument() ? 79 : 97);
        result = result * 59 + this.getDefaultPageSize();
        result = result * 59 + (this.isServiceRunning() ? 79 : 97);
        result = result * 59 + (this.isCache() ? 79 : 97);
        result = result * 59 + this.getCacheExpireSecond();
        result = result * 59 + this.getAuthorizeExpireTime();
        result = result * 59 + (this.isDebug() ? 79 : 97);
        String $defaultSortField = this.getDefaultSortField();
        result = result * 59 + ($defaultSortField == null ? 43 : $defaultSortField.hashCode());
        String $defaultSortDirection = this.getDefaultSortDirection();
        result = result * 59 + ($defaultSortDirection == null ? 43 : $defaultSortDirection.hashCode());
        String $authorizeHeader = this.getAuthorizeHeader();
        result = result * 59 + ($authorizeHeader == null ? 43 : $authorizeHeader.hashCode());
        String $tenantHeader = this.getTenantHeader();
        result = result * 59 + ($tenantHeader == null ? 43 : $tenantHeader.hashCode());
        MqttConfig $mqtt = this.getMqtt();
        result = result * 59 + ($mqtt == null ? 43 : ((Object)$mqtt).hashCode());
        CookieConfig $cookie = this.getCookie();
        result = result * 59 + ($cookie == null ? 43 : ((Object)$cookie).hashCode());
        return result;
    }

    public String toString() {
        return "GlobalConfig(enableDocument=" + this.isEnableDocument() + ", defaultPageSize=" + this.getDefaultPageSize() + ", isServiceRunning=" + this.isServiceRunning() + ", cache=" + this.isCache() + ", cacheExpireSecond=" + this.getCacheExpireSecond() + ", defaultSortField=" + this.getDefaultSortField() + ", defaultSortDirection=" + this.getDefaultSortDirection() + ", authorizeHeader=" + this.getAuthorizeHeader() + ", authorizeExpireTime=" + this.getAuthorizeExpireTime() + ", tenantHeader=" + this.getTenantHeader() + ", debug=" + this.isDebug() + ", mqtt=" + this.getMqtt() + ", cookie=" + this.getCookie() + ")";
    }
}

