/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.annotation.Description;
import cn.hamm.airpower.root.RootController;
import cn.hamm.airpower.root.RootEntity;
import cn.hamm.airpower.root.RootModel;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.springframework.web.bind.annotation.PostMapping;

public class ReflectUtil {
    public static PostMapping getPostMapping(Method method) {
        return ReflectUtil.getPostMapping(method, method.getDeclaringClass());
    }

    public static String getDescription(Class<?> clazz) {
        Description description = clazz.getAnnotation(Description.class);
        if (Objects.nonNull(description)) {
            return description.value();
        }
        if (clazz.getName().equals(RootController.class.getName()) || clazz.getName().equals(Object.class.getName())) {
            return clazz.getSimpleName();
        }
        Class<?> superClass = clazz.getSuperclass();
        return ReflectUtil.getDescription(superClass);
    }

    public static String getDescription(Method method) {
        return ReflectUtil.getDescription(method, method.getDeclaringClass());
    }

    public static String getDescription(Field field) {
        Description description = field.getAnnotation(Description.class);
        return Objects.isNull(description) ? field.getName() : description.value();
    }

    public static boolean isEntity(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            return false;
        }
        if (clazz.getSimpleName().equalsIgnoreCase(RootEntity.class.getSimpleName())) {
            return true;
        }
        return ReflectUtil.isEntity(clazz.getSuperclass());
    }

    public static boolean isModel(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            return false;
        }
        if (clazz.getSimpleName().equalsIgnoreCase(RootModel.class.getSimpleName())) {
            return true;
        }
        return ReflectUtil.isModel(clazz.getSuperclass());
    }

    public static List<Field> getFieldList(Class<?> clazz) {
        Field[] fields;
        LinkedList<Field> fieldList = new LinkedList<Field>();
        if (Objects.isNull(clazz)) {
            return fieldList;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            fieldList.add(field);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (Objects.isNull(superClass) || Object.class.equals(superClass)) {
            return fieldList;
        }
        fieldList.addAll(ReflectUtil.getFieldList(superClass));
        return fieldList;
    }

    public static List<String> getFieldNameList(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields) {
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }

    private static PostMapping getPostMapping(Method method, Class<?> clazz) {
        PostMapping postMapping = method.getAnnotation(PostMapping.class);
        if (Objects.nonNull(postMapping)) {
            return postMapping;
        }
        if (clazz.getName().equals(RootController.class.getName()) || clazz.getName().equals(Object.class.getName())) {
            return null;
        }
        Class<?> superClass = clazz.getSuperclass();
        try {
            Method superMethod = superClass.getMethod(method.getName(), RootEntity.class);
            return ReflectUtil.getPostMapping(superMethod, superClass);
        }
        catch (NoSuchMethodException e) {
            superClass = superClass.getSuperclass();
            if (Objects.isNull(superClass)) {
                return null;
            }
            return ReflectUtil.getPostMapping(method, superClass);
        }
    }

    private static String getDescription(Method method, Class<?> clazz) {
        Description description = method.getAnnotation(Description.class);
        if (Objects.nonNull(description)) {
            return description.value();
        }
        if (clazz.getName().equals(RootController.class.getName()) || clazz.getName().equals(Object.class.getName())) {
            return method.getName();
        }
        Class<?> superClass = clazz.getSuperclass();
        try {
            Method superMethod = superClass.getMethod(method.getName(), RootEntity.class);
            return ReflectUtil.getDescription(superMethod, superClass);
        }
        catch (NoSuchMethodException e) {
            superClass = superClass.getSuperclass();
            return ReflectUtil.getDescription(method, superClass);
        }
    }
}

