/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.response;

import cn.hamm.airpower.query.QueryPageResponse;
import cn.hamm.airpower.response.Filter;
import cn.hamm.airpower.result.json.JsonData;
import cn.hamm.airpower.root.RootModel;
import cn.hamm.airpower.util.ReflectUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ResponseAspect {
    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.PostMapping)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object responseFilter(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = signature.getMethod();
        Class<?> returnCls = method.getReturnType();
        Object result = proceedingJoinPoint.proceed();
        if (!JsonData.class.equals(returnCls)) {
            return result;
        }
        Filter filter = method.getAnnotation(Filter.class);
        if (Objects.isNull(filter)) {
            return result;
        }
        JsonData jsonData = (JsonData)result;
        Class<?> dataCls = jsonData.getData().getClass();
        if (ArrayList.class.equals(dataCls)) {
            List list = (List)jsonData.getData();
            jsonData.setData(this.filterResponseListBy(filter, list));
            return jsonData;
        }
        if (QueryPageResponse.class.equals(dataCls)) {
            QueryPageResponse queryPageResponse = (QueryPageResponse)jsonData.getData();
            List list = queryPageResponse.getList();
            this.filterResponseListBy(filter, list);
            jsonData.setData(queryPageResponse.setList(list));
            return jsonData;
        }
        if (ReflectUtil.isModel(dataCls)) {
            jsonData.setData(this.filterResponseBy(filter, (RootModel)jsonData.getData()));
        }
        return jsonData;
    }

    private RootModel<?> filterResponseBy(Filter filter, RootModel<?> data) {
        return data.filterResponseDataBy(Objects.isNull(filter) ? Void.class : filter.value());
    }

    private List<?> filterResponseListBy(Filter filter, List<?> list) {
        try {
            for (Object item : list) {
                Class<?> clazz = item.getClass();
                if (!ReflectUtil.isModel(clazz)) continue;
                this.filterResponseBy(filter, (RootModel)item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }
}

