/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.interfaces.IDictionary;
import cn.hamm.airpower.result.Result;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DictionaryUtil {
    public static <T extends IDictionary> T getDictionaryByKey(Class<T> enumClass, int key) {
        try {
            T[] objs;
            Method getKey = enumClass.getMethod("getKey", new Class[0]);
            for (T obj : objs = enumClass.getEnumConstants()) {
                int exitValue = (Integer)getKey.invoke(obj, new Object[0]);
                if (exitValue != key) continue;
                return (T)((IDictionary)obj);
            }
        }
        catch (Exception ignored) {
            Result.PARAM_INVALID.show(key + "\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185");
        }
        return null;
    }

    @NotNull
    public static List<Map<String, String>> getDictionaryList(@NotNull Class<?> clazz, String ... params) {
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        for (Object obj : clazz.getEnumConstants()) {
            HashMap<String, String> item = new HashMap<String, String>(params.length);
            for (String param : params) {
                try {
                    Method method = clazz.getMethod("get" + StrUtil.upperFirst((CharSequence)param), new Class[0]);
                    item.put(param, method.invoke(obj, new Object[0]).toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            mapList.add(item);
        }
        return mapList;
    }

    @NotNull
    public static <T extends IDictionary> List<Map<String, String>> getDictionaryList(Class<T> clazz) {
        return DictionaryUtil.getDictionaryList(clazz, "key", "label");
    }
}

