/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.security;

import cn.hamm.airpower.config.GlobalConfig;
import cn.hamm.airpower.security.SecurityUtil;
import jakarta.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Component
public class AccessResolver
implements HandlerMethodArgumentResolver {
    @Autowired
    private SecurityUtil securityUtil;
    @Autowired
    private GlobalConfig globalConfig;

    public boolean supportsParameter(MethodParameter parameter) {
        Class clazz = parameter.getParameterType();
        return clazz == Long.class;
    }

    public Object resolveArgument(@NotNull MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        String accessToken = null;
        if (request != null) {
            accessToken = request.getHeader(this.globalConfig.getAuthorizeHeader());
        }
        return this.securityUtil.getUserIdFromAccessToken(accessToken);
    }
}

