/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.security;

import cn.hamm.airpower.config.GlobalConfig;
import cn.hamm.airpower.result.Result;
import cn.hamm.airpower.security.AccessConfig;
import cn.hamm.airpower.security.AccessUtil;
import cn.hamm.airpower.security.SecurityUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public abstract class AbstractAccessInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractAccessInterceptor.class);
    @Autowired
    private SecurityUtil securityUtil;
    @Autowired
    private GlobalConfig globalConfig;

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object object) {
        HandlerMethod handlerMethod = (HandlerMethod)object;
        this.beforeHandleRequest(request, response, handlerMethod);
        Class clazz = handlerMethod.getBeanType();
        Method method = handlerMethod.getMethod();
        AccessConfig accessConfig = AccessUtil.getWhatNeedAccess(clazz, method);
        if (!accessConfig.login) {
            return true;
        }
        String accessToken = request.getHeader(this.globalConfig.getAuthorizeHeader());
        Result.UNAUTHORIZED.whenEmpty(accessToken);
        Long userId = this.securityUtil.getUserIdFromAccessToken(accessToken);
        if (accessConfig.authorize) {
            return this.checkPermissionAccess(userId, AccessUtil.getPermissionIdentity(clazz, method), request);
        }
        return true;
    }

    public abstract boolean checkPermissionAccess(Long var1, String var2, HttpServletRequest var3);

    protected void beforeHandleRequest(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod) {
    }
}

