/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.root;

import cn.hamm.airpower.annotation.ReadOnly;
import cn.hamm.airpower.annotation.Search;
import cn.hamm.airpower.config.GlobalConfig;
import cn.hamm.airpower.model.Sort;
import cn.hamm.airpower.query.QueryPageRequest;
import cn.hamm.airpower.query.QueryPageResponse;
import cn.hamm.airpower.query.QueryRequest;
import cn.hamm.airpower.result.Result;
import cn.hamm.airpower.result.ResultException;
import cn.hamm.airpower.root.RootEntity;
import cn.hamm.airpower.root.RootRepository;
import cn.hamm.airpower.security.SecurityUtil;
import cn.hamm.airpower.util.ReflectUtil;
import cn.hamm.airpower.util.redis.RedisUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import jakarta.persistence.Column;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

public class RootService<E extends RootEntity<E>, R extends RootRepository<E>> {
    private static final Logger log = LoggerFactory.getLogger(RootService.class);
    @Autowired
    protected R repository;
    @Autowired
    private GlobalConfig globalConfig;
    @Autowired
    protected RedisUtil<E> redisUtil;
    @Autowired
    protected SecurityUtil secureUtil;
    @Autowired
    private EntityManager entityManager;

    public E add(E entity) {
        return this.addToDatabase(entity);
    }

    public E get(Long id) {
        return this.getById(id);
    }

    public E getMaybeNull(Long id) {
        return this.getByIdMaybeNull(id);
    }

    public E update(E entity) {
        return this.updateToDatabase(entity);
    }

    public E disable(Long id) {
        return this.disableById(id);
    }

    public E enable(Long id) {
        return this.enableById(id);
    }

    public void delete(Long id) {
        this.deleteById(id);
    }

    public final List<E> getList(QueryRequest<E> queryRequest) {
        if (Objects.isNull(queryRequest)) {
            queryRequest = new QueryRequest();
        }
        if (Objects.isNull(queryRequest.getFilter())) {
            queryRequest.setFilter(this.getNewInstance());
        }
        queryRequest = this.beforeGetList(queryRequest);
        List list = this.repository.findAll(this.createSpecification(queryRequest), this.createSort(queryRequest));
        return this.afterGetList(list);
    }

    public final QueryPageResponse<E> getPage(QueryPageRequest<E> queryPageRequest) {
        if (Objects.isNull(queryPageRequest)) {
            queryPageRequest = new QueryPageRequest();
        }
        if (Objects.isNull(queryPageRequest.getFilter())) {
            queryPageRequest.setFilter(this.getNewInstance());
        }
        queryPageRequest = this.beforeGetPage(queryPageRequest);
        QueryPageResponse<E> queryPageResponse = this.getResponsePageList(this.repository.findAll(this.createSpecification(queryPageRequest), this.createPageable(queryPageRequest))).setSort(queryPageRequest.getSort());
        return this.afterGetPage(queryPageResponse);
    }

    protected <T extends QueryPageRequest<E>> T beforeGetPage(T sourceRequestData) {
        return sourceRequestData;
    }

    protected QueryPageResponse<E> afterGetPage(QueryPageResponse<E> queryPageResponse) {
        return queryPageResponse;
    }

    protected List<E> afterGetList(List<E> list) {
        return list;
    }

    protected <T extends QueryRequest<E>> T beforeGetList(T sourceRequestData) {
        return sourceRequestData;
    }

    protected E beforeSaveToDatabase(E entity) {
        return entity;
    }

    protected final E disableById(Long id) {
        E entity = this.get(id);
        return this.saveToDatabase(((RootEntity)entity).setIsDisabled(true));
    }

    protected final E enableById(Long id) {
        E entity = this.get(id);
        return this.saveToDatabase(((RootEntity)entity).setIsDisabled(false));
    }

    protected final void deleteById(Long id) {
        this.repository.deleteById((Object)id);
    }

    protected final E getById(Long id) {
        Result.PARAM_MISSING.whenNull(id, "\u67e5\u8be2\u5931\u8d25, \u8bf7\u4f20\u5165" + ReflectUtil.getDescription(this.getEntityClass()) + "ID!");
        Optional optional = this.repository.findById((Object)id);
        if (optional.isPresent()) {
            return (E)((RootEntity)optional.get());
        }
        Result.DATA_NOT_FOUND.show("\u6ca1\u6709\u67e5\u5230ID\u4e3a" + id + "\u7684" + ReflectUtil.getDescription(this.getEntityClass()) + "!");
        return this.getNewInstance();
    }

    protected final E getByIdMaybeNull(Long id) {
        try {
            return this.get(id);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected final E addToDatabase(E entity) {
        ((RootEntity)((RootEntity)((RootEntity)((RootEntity)entity).setId(null)).setIsDisabled(false)).setCreateTime(DateUtil.current())).setUpdateTime(((RootEntity)entity).getCreateTime());
        if (Objects.isNull(((RootEntity)entity).getRemark())) {
            ((RootEntity)entity).setRemark("");
        }
        return this.saveToDatabase(entity);
    }

    protected final E updateToDatabase(E entity) {
        Result.PARAM_MISSING.whenNull(((RootEntity)entity).getId(), "\u4fee\u6539\u5931\u8d25, \u8bf7\u4f20\u5165" + ReflectUtil.getDescription(this.getEntityClass()) + "ID!");
        return this.saveToDatabase(entity);
    }

    protected final E ignoreReadOnlyFields(E entity) {
        List<Field> fields = ReflectUtil.getFieldList(this.getEntityClass());
        for (Field field : fields) {
            ReadOnly annotation = field.getAnnotation(ReadOnly.class);
            if (Objects.isNull(annotation)) continue;
            try {
                field.setAccessible(true);
                field.set(entity, null);
            }
            catch (Exception e) {
                Result.ERROR.show();
            }
        }
        return entity;
    }

    private E saveToDatabase(E entity) {
        this.checkUnique(entity);
        ((RootEntity)entity).setUpdateTime(DateUtil.current());
        if (Objects.nonNull(((RootEntity)entity).getId())) {
            E existEntity = this.get(((RootEntity)entity).getId());
            if (Objects.isNull(((RootEntity)existEntity).getRemark()) && Objects.isNull(((RootEntity)entity).getRemark())) {
                ((RootEntity)entity).setRemark("");
            }
            entity = this.getEntityForSave(entity, existEntity);
        }
        Object target = this.getNewInstance();
        BeanUtils.copyProperties(entity, target);
        target = this.beforeSaveToDatabase(target);
        target = (RootEntity)this.repository.saveAndFlush(target);
        long id = ((RootEntity)target).getId();
        this.entityManager.clear();
        return this.getById(id);
    }

    private E getEntityForSave(E sourceEntity, E targetEntity) {
        String[] nullProperties = this.getNullProperties(sourceEntity);
        BeanUtils.copyProperties(sourceEntity, targetEntity, (String[])nullProperties);
        return targetEntity;
    }

    private void checkUnique(E entity) {
        List<Field> fields = ReflectUtil.getFieldList(this.getEntityClass());
        for (Field field : fields) {
            String fieldName = ReflectUtil.getDescription(field);
            Column annotation = field.getAnnotation(Column.class);
            if (Objects.isNull(annotation) || !annotation.unique()) continue;
            Object fieldValue = "";
            try {
                field.setAccessible(true);
                fieldValue = field.get(entity);
                if (Objects.isNull(fieldValue)) continue;
                E search = this.getNewInstance();
                field.set(search, fieldValue);
                Example example = Example.of(search);
                Optional exist = this.repository.findOne(example);
                if (exist.isEmpty() || Objects.nonNull(((RootEntity)entity).getId()) && ((RootEntity)exist.get()).getId().equals(((RootEntity)entity).getId())) {
                    continue;
                }
            }
            catch (Exception e) {
                Result.ERROR.show();
            }
            Result.FORBIDDEN_EXIST.show(fieldName + "(" + fieldValue.toString() + ")\u5df2\u7ecf\u5b58\u5728\uff01");
        }
    }

    private E getNewInstance() {
        try {
            return (E)((RootEntity)this.getEntityClass().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new ResultException("\u521d\u59cb\u5316\u5b9e\u4f53\u5931\u8d25");
        }
    }

    private Class<E> getEntityClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    private String[] getNullProperties(Object src) {
        BeanWrapperImpl srcBean = new BeanWrapperImpl(src);
        PropertyDescriptor[] pds = srcBean.getPropertyDescriptors();
        HashSet<String> properties = new HashSet<String>();
        for (PropertyDescriptor propertyDescriptor : pds) {
            String propertyName = propertyDescriptor.getName();
            Object propertyValue = srcBean.getPropertyValue(propertyName);
            if (!Objects.isNull(propertyValue)) continue;
            srcBean.setPropertyValue(propertyName, null);
            properties.add(propertyName);
        }
        return properties.toArray(new String[0]);
    }

    private QueryPageResponse<E> getResponsePageList(Page<E> data) {
        return new QueryPageResponse().setList(data.getContent()).setTotal(Math.toIntExact(data.getTotalElements())).setPageCount(data.getTotalPages()).setPage(new cn.hamm.airpower.model.Page().setPageSize(data.getPageable().getPageSize()).setPageNum(data.getPageable().getPageNumber() + 1));
    }

    private org.springframework.data.domain.Sort createSort(QueryRequest<E> queryRequest) {
        if (Objects.isNull(queryRequest.getSort())) {
            queryRequest.setSort(new Sort());
        }
        if (StrUtil.isBlank((CharSequence)queryRequest.getSort().getField())) {
            queryRequest.getSort().setField(this.globalConfig.getDefaultSortField());
        }
        if (StrUtil.isBlank((CharSequence)queryRequest.getSort().getDirection())) {
            queryRequest.getSort().setDirection(this.globalConfig.getDefaultSortDirection());
        }
        if (!this.globalConfig.getDefaultSortDirection().equals(queryRequest.getSort().getDirection())) {
            return org.springframework.data.domain.Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)queryRequest.getSort().getField())});
        }
        return org.springframework.data.domain.Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)queryRequest.getSort().getField())});
    }

    private Pageable createPageable(QueryPageRequest<E> queryPageData) {
        org.springframework.data.domain.Sort sort = this.createSort(queryPageData);
        cn.hamm.airpower.model.Page page = queryPageData.getPage();
        if (Objects.isNull(page)) {
            page = new cn.hamm.airpower.model.Page();
        }
        if (Objects.isNull(page.getPageNum())) {
            page.setPageNum(1);
        }
        if (Objects.isNull(page.getPageSize())) {
            page.setPageSize(this.globalConfig.getDefaultPageSize());
        }
        int pageNumber = page.getPageNum() - 1;
        pageNumber = Math.max(0, pageNumber);
        int pageSize = queryPageData.getPage().getPageSize();
        pageSize = Math.max(1, pageSize);
        return PageRequest.of((int)pageNumber, (int)pageSize, (org.springframework.data.domain.Sort)sort);
    }

    private List<Predicate> getPredicateList(Object root, CriteriaBuilder builder, Object search, boolean isRoot) {
        ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
        List<Field> fields = ReflectUtil.getFieldList(search.getClass());
        for (Field field : fields) {
            try {
                Search searchMode;
                field.setAccessible(true);
                Object fieldValue = field.get(search);
                if (Objects.isNull(fieldValue) || StrUtil.isEmpty((CharSequence)fieldValue.toString()) || Objects.isNull(searchMode = field.getAnnotation(Search.class))) continue;
                if (searchMode.value() == Search.Mode.JOIN) {
                    if (!isRoot) continue;
                    Join payload = ((Root)root).join(field.getName(), JoinType.INNER);
                    predicateList.addAll(this.getPredicateList(payload, builder, fieldValue, false));
                    continue;
                }
                Object searchValue = fieldValue.toString();
                if (Boolean.class.equals(fieldValue.getClass())) {
                    if (isRoot) {
                        predicateList.add(builder.equal((Expression)((Root)root).get(field.getName()), fieldValue));
                        continue;
                    }
                    predicateList.add(builder.equal((Expression)((Join)root).get(field.getName()), fieldValue));
                    continue;
                }
                if (Search.Mode.LIKE.equals((Object)searchMode.value())) {
                    searchValue = "%" + (String)searchValue + "%";
                    if (isRoot) {
                        predicateList.add(builder.like((Expression)((Root)root).get(field.getName()), (String)searchValue));
                        continue;
                    }
                    predicateList.add(builder.like((Expression)((Join)root).get(field.getName()), (String)searchValue));
                    continue;
                }
                if (isRoot) {
                    predicateList.add(builder.equal((Expression)((Root)root).get(field.getName()), fieldValue));
                    continue;
                }
                predicateList.add(builder.equal((Expression)((Join)root).get(field.getName()), fieldValue));
            }
            catch (IllegalAccessException exception) {
                log.error(exception.getMessage());
            }
        }
        return predicateList;
    }

    private Specification<E> createSpecification(QueryRequest<E> queryRequest) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> this.createPredicate(root, criteriaQuery, criteriaBuilder, queryRequest.getFilter());
    }

    protected Predicate createPredicate(Root<E> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder builder, E search) {
        List<Predicate> predicateList = this.getPredicateList(root, builder, search, true);
        Predicate[] predicates = new Predicate[predicateList.size()];
        criteriaQuery.where((Expression)builder.and(predicateList.toArray(predicates)));
        return criteriaQuery.getRestriction();
    }
}

