/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.root;

import cn.hamm.airpower.annotation.Description;
import cn.hamm.airpower.api.Api;
import cn.hamm.airpower.api.Extends;
import cn.hamm.airpower.query.QueryPageRequest;
import cn.hamm.airpower.query.QueryPageResponse;
import cn.hamm.airpower.query.QueryRequest;
import cn.hamm.airpower.response.Filter;
import cn.hamm.airpower.result.Result;
import cn.hamm.airpower.result.ResultException;
import cn.hamm.airpower.result.json.Json;
import cn.hamm.airpower.result.json.JsonData;
import cn.hamm.airpower.root.RootController;
import cn.hamm.airpower.root.RootEntity;
import cn.hamm.airpower.root.RootRepository;
import cn.hamm.airpower.root.RootService;
import cn.hamm.airpower.security.Permission;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Permission
public class RootEntityController<E extends RootEntity<E>, S extends RootService<E, R>, R extends RootRepository<E>>
extends RootController {
    @Autowired
    protected S service;

    @Description(value="\u6dfb\u52a0")
    @PostMapping(value={"add"})
    @Filter(value=RootEntity.WhenGetDetail.class)
    public JsonData add(@RequestBody @Validated(value={RootEntity.WhenAdd.class}) E entity) {
        this.checkApiAvailableStatus(Api.Add);
        return this.jsonData(this.afterAdd(((RootService)this.service).add(this.beforeAdd(((RootService)this.service).ignoreReadOnlyFields(entity)))), "\u521b\u5efa\u6210\u529f");
    }

    @Description(value="\u5220\u9664")
    @PostMapping(value={"delete"})
    public Json delete(@RequestBody @Validated(value={RootEntity.WhenIdRequired.class}) E entity) {
        this.checkApiAvailableStatus(Api.Delete);
        this.beforeDelete(entity);
        ((RootService)this.service).delete(((RootEntity)entity).getId());
        this.afterDelete(entity);
        return this.json("\u5220\u9664\u6210\u529f");
    }

    @Description(value="\u4fee\u6539")
    @PostMapping(value={"update"})
    @Filter(value=RootEntity.WhenGetDetail.class)
    public JsonData update(@RequestBody @Validated(value={RootEntity.WhenUpdate.class}) E entity) {
        this.checkApiAvailableStatus(Api.Update);
        return this.jsonData(this.afterUpdate(((RootService)this.service).update(this.beforeUpdate(((RootService)this.service).ignoreReadOnlyFields(entity)))), "\u4fee\u6539\u6210\u529f");
    }

    @Description(value="\u67e5\u8be2\u8be6\u60c5")
    @PostMapping(value={"getDetail"})
    @Filter(value=RootEntity.WhenGetDetail.class)
    public JsonData getDetail(@RequestBody @Validated(value={RootEntity.WhenIdRequired.class}) E entity) {
        this.checkApiAvailableStatus(Api.GetDetail);
        return this.jsonData(this.afterGetDetail(((RootService)this.service).get(((RootEntity)entity).getId())));
    }

    @Description(value="\u7981\u7528")
    @PostMapping(value={"disable"})
    public Json disable(@RequestBody @Validated(value={RootEntity.WhenIdRequired.class}) E entity) {
        this.checkApiAvailableStatus(Api.Disable);
        this.beforeDisable(entity);
        this.afterDisable(((RootService)this.service).disable(((RootEntity)entity).getId()));
        return this.json("\u7981\u7528\u6210\u529f");
    }

    @Description(value="\u542f\u7528")
    @PostMapping(value={"enable"})
    public Json enable(@RequestBody @Validated(value={RootEntity.WhenIdRequired.class}) E entity) {
        this.checkApiAvailableStatus(Api.Enable);
        this.beforeEnable(entity);
        this.afterEnable(((RootService)this.service).enable(((RootEntity)entity).getId()));
        return this.json("\u542f\u7528\u6210\u529f");
    }

    @Description(value="\u4e0d\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"getList"})
    @Filter(value=RootEntity.WhenGetList.class)
    public JsonData getList(@RequestBody QueryRequest<E> queryRequest) {
        queryRequest = this.getQueryRequest(queryRequest);
        this.checkApiAvailableStatus(Api.GetList);
        return this.jsonData(this.afterGetList(((RootService)this.service).getList(this.beforeGetList(queryRequest))));
    }

    @Description(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"getPage"})
    @Filter(value=RootEntity.WhenGetPage.class)
    public JsonData getPage(@RequestBody QueryPageRequest<E> queryPageRequest) {
        queryPageRequest = this.getQueryRequest(queryPageRequest);
        this.checkApiAvailableStatus(Api.GetPage);
        return this.jsonData(this.afterGetPage(((RootService)this.service).getPage(this.beforeGetPage(queryPageRequest))));
    }

    protected <T extends QueryPageResponse<E>> T afterGetPage(T queryPageResponse) {
        return queryPageResponse;
    }

    protected <T extends QueryPageRequest<E>> T beforeGetPage(T queryPageRequest) {
        return queryPageRequest;
    }

    protected <T extends QueryRequest<E>> T beforeGetList(T queryRequest) {
        return queryRequest;
    }

    protected List<E> afterGetList(List<E> list) {
        return list;
    }

    protected E afterGetDetail(E entity) {
        return entity;
    }

    protected E beforeAdd(E entity) {
        return entity;
    }

    protected E afterAdd(E entity) {
        return entity;
    }

    protected E beforeUpdate(E entity) {
        return entity;
    }

    protected E afterUpdate(E entity) {
        return entity;
    }

    protected void beforeDelete(E entity) {
    }

    protected void afterDelete(E entity) {
    }

    protected void beforeDisable(E entity) {
    }

    protected void afterDisable(E entity) {
    }

    protected void beforeEnable(E entity) {
    }

    protected void afterEnable(E entity) {
    }

    private <T extends QueryRequest<E>> T getQueryRequest(T queryRequest) {
        if (Objects.isNull(queryRequest)) {
            queryRequest = new QueryRequest();
        }
        if (Objects.isNull(((QueryRequest)queryRequest).getFilter())) {
            ((QueryRequest)queryRequest).setFilter(this.getNewInstance());
        }
        return (T)queryRequest;
    }

    private void checkApiAvailableStatus(Api api) {
        Extends extendsApi = this.getClass().getAnnotation(Extends.class);
        if (Objects.isNull(extendsApi)) {
            return;
        }
        if (extendsApi.value().length == 0 && extendsApi.exclude().length == 0) {
            return;
        }
        if (extendsApi.value().length > 0 && Arrays.asList(extendsApi.value()).contains((Object)api)) {
            return;
        }
        if (extendsApi.exclude().length > 0 && !Arrays.asList(extendsApi.exclude()).contains((Object)api)) {
            return;
        }
        Result.API_SERVICE_UNSUPPORTED.show("\u8be5\u63a5\u53e3\u6682\u672a\u63d0\u4f9b");
    }

    private E getNewInstance() {
        try {
            return (E)((RootEntity)this.getEntityClass().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new ResultException("\u521d\u59cb\u5316\u5b9e\u4f53\u5931\u8d25");
        }
    }

    private Class<E> getEntityClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }
}

