/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConfigurationProperties(value="airpower.cookie")
public class CookieConfig {
    private String cookiePath = "/";
    private String authCookieName = "authorization-key";
    private boolean cookieHttpOnly = true;
    private int cookieMaxAge = 86400;
    private boolean cookieSecurity = true;

    public String getCookiePath() {
        return this.cookiePath;
    }

    public String getAuthCookieName() {
        return this.authCookieName;
    }

    public boolean isCookieHttpOnly() {
        return this.cookieHttpOnly;
    }

    public int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public boolean isCookieSecurity() {
        return this.cookieSecurity;
    }

    public CookieConfig setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
        return this;
    }

    public CookieConfig setAuthCookieName(String authCookieName) {
        this.authCookieName = authCookieName;
        return this;
    }

    public CookieConfig setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
        return this;
    }

    public CookieConfig setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
        return this;
    }

    public CookieConfig setCookieSecurity(boolean cookieSecurity) {
        this.cookieSecurity = cookieSecurity;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CookieConfig)) {
            return false;
        }
        CookieConfig other = (CookieConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCookieHttpOnly() != other.isCookieHttpOnly()) {
            return false;
        }
        if (this.getCookieMaxAge() != other.getCookieMaxAge()) {
            return false;
        }
        if (this.isCookieSecurity() != other.isCookieSecurity()) {
            return false;
        }
        String this$cookiePath = this.getCookiePath();
        String other$cookiePath = other.getCookiePath();
        if (this$cookiePath == null ? other$cookiePath != null : !this$cookiePath.equals(other$cookiePath)) {
            return false;
        }
        String this$authCookieName = this.getAuthCookieName();
        String other$authCookieName = other.getAuthCookieName();
        return !(this$authCookieName == null ? other$authCookieName != null : !this$authCookieName.equals(other$authCookieName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CookieConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCookieHttpOnly() ? 79 : 97);
        result = result * 59 + this.getCookieMaxAge();
        result = result * 59 + (this.isCookieSecurity() ? 79 : 97);
        String $cookiePath = this.getCookiePath();
        result = result * 59 + ($cookiePath == null ? 43 : $cookiePath.hashCode());
        String $authCookieName = this.getAuthCookieName();
        result = result * 59 + ($authCookieName == null ? 43 : $authCookieName.hashCode());
        return result;
    }

    public String toString() {
        return "CookieConfig(cookiePath=" + this.getCookiePath() + ", authCookieName=" + this.getAuthCookieName() + ", cookieHttpOnly=" + this.isCookieHttpOnly() + ", cookieMaxAge=" + this.getCookieMaxAge() + ", cookieSecurity=" + this.isCookieSecurity() + ")";
    }
}

