package cn.gybyt.web.config;

import cn.gybyt.web.config.properties.GybytMybatisProperties;
import cn.gybyt.web.interceptor.GybytMybatisSqlLogInterceptor;
import cn.gybyt.web.plugins.GybytMybatisMapperRefreshPlugin;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

/**
 * mybatis配置类
 * @program: utils
 * @classname: GybytMybatisConfig
 * @author: codetiger
 * @create: 2023/3/4 11:30
 **/
@Configuration
@ConditionalOnClass(Select.class)
public class GybytMybatisConfig {

    @Resource
    private GybytMybatisProperties gybytMybatisProperties;

    /**
     * mybatis xml文件位置
     */
    @Value("${mybatis.mapper-locations}")
    private String packageSearchPath;

    @Bean
    @ConditionalOnProperty(prefix = "gybyt.mybatis", name = "sql-log", havingValue = "true")
    public GybytMybatisSqlLogInterceptor gybytMybatisSqlLogInterceptor() {
        return new GybytMybatisSqlLogInterceptor(gybytMybatisProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix = "gybyt.mybatis", name = "enable-refresh", havingValue = "true")
    public void gybytMybatisMapperRefreshPlugin() {
        GybytMybatisMapperRefreshPlugin gybytMybatisMapperRefreshPlugin = new GybytMybatisMapperRefreshPlugin(packageSearchPath, gybytMybatisProperties.getRefreshInterval() == null ? 3L : gybytMybatisProperties.getRefreshInterval());
        gybytMybatisMapperRefreshPlugin.init();
    }
}
