package cn.gybyt.util;

import cn.gybyt.web.util.HttpStatusEnum;
import org.springframework.lang.NonNull;

/**
 * 公共异常
 *
 * @program: utils
 * @classname: BaseException
 * @author: codetiger
 * @create: 2021/5/19 11:39
 **/

public class BaseException extends RuntimeException {
    /**
     * 状态码
     */
    int code = HttpStatusEnum.BUSINESSERROR.value();
    /**
     * http状态码
     */
    int httpStatus = HttpStatusEnum.SUCCESS.value();
    /**
     * 错误信息
     */
    String msg;
    /**
     * 是否修改状态码
     */
    Boolean changeHttpStatus;

    /**
     * 默认构造方法
     */
    public BaseException() {
    }

    /**
     * 错误信息，默认400错误
     * @param msg
     */
    public BaseException(String  msg){
        super(msg);
        this.msg = msg;
        this.changeHttpStatus = false;
    }
    /**
     * @param msg 错误信息
     * @param cause
     */
    public BaseException(String msg, Throwable cause) {
        super(msg, cause);
        this.msg = msg;
        this.changeHttpStatus = false;
    }

    /**
     * @param code 错误码
     * @param msg 错误信息
     * @return
     * @Author codetiger
     * @Description //TODO
     * @Date 22:39 2022/5/15
     * @Param
     **/
    public BaseException(Integer code, String msg) {
        super(msg);
        this.code = code;
        this.msg = msg;
        this.changeHttpStatus = false;
    }

    /**
     * @param code 错误码
     * @param msg 错误信息
     * @param changeHttpStatus 是否更改http状态码
     * @return
     * @Author codetiger
     * @Description //TODO
     * @Date 22:39 2022/5/15
     * @Param
     **/
    public BaseException(Integer code, String msg, @NonNull Boolean changeHttpStatus) {
        super(msg);
        this.code = code;
        this.msg = msg;
        this.changeHttpStatus = changeHttpStatus;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Boolean getChangeHttpStatus() {
        return changeHttpStatus;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getHttpStatus() {
        return httpStatus;
    }

    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    public void setChangeHttpStatus(Boolean changeHttpStatus) {
        this.changeHttpStatus = changeHttpStatus;
    }
}
