/*
 * Decompiled with CFR 0.152.
 */
package cn.gybyt.util.web;

import cn.gybyt.util.BaseException;
import cn.gybyt.util.BaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ControllerExceptionAdvice {
    private final Logger log = LoggerFactory.getLogger(ControllerExceptionAdvice.class);

    @ExceptionHandler(value={BindException.class})
    public BaseResponse MethodArgumentNotValidExceptionHandler(BindException e) {
        ObjectError objectError = (ObjectError)e.getBindingResult().getAllErrors().get(0);
        this.log.error(objectError.getDefaultMessage());
        return new BaseResponse(500, objectError.getDefaultMessage());
    }

    @ExceptionHandler(value={BaseException.class})
    public BaseResponse APIExceptionHandler(BaseException e) {
        this.log.error(e.getMessage());
        return new BaseResponse(e.getCode(), e.getMessage());
    }
}

