package cn.gybyt.config;

import cn.gybyt.config.properties.GybytMybatisProperties;
import cn.gybyt.interceptor.GybytMybatisSqlLogInterceptor;
import cn.gybyt.plugins.GybytMybatisMapperRefreshPlugin;
import org.apache.ibatis.annotations.Select;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

/**
 * mybatis配置类
 * @program: utils
 * @classname: GybytMybatisConfig
 * @author: codetiger
 * @create: 2023/3/4 11:30
 **/
@Configuration
@ConditionalOnClass(Select.class)
@ConditionalOnBean(GybytMybatisProperties.class)
public class GybytMybatisConfig {

    @Resource
    private GybytMybatisProperties gybytMybatisProperties;

    @Bean
    @ConditionalOnProperty(prefix = "gybyt.mybatis", name = "sql-log", havingValue = "true")
    public GybytMybatisSqlLogInterceptor gybytMybatisSqlLogInterceptor() {
        return new GybytMybatisSqlLogInterceptor(gybytMybatisProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix = "gybyt.mybatis", name = "enable-refresh", havingValue = "true")
    public void gybytMybatisMapperRefreshPlugin() {
        GybytMybatisMapperRefreshPlugin gybytMybatisMapperRefreshPlugin = new GybytMybatisMapperRefreshPlugin(gybytMybatisProperties.getMapperPath(), gybytMybatisProperties.getRefreshInterval() == null ? 3L : gybytMybatisProperties.getRefreshInterval());
        gybytMybatisMapperRefreshPlugin.init();
    }
}
