/*
 * Decompiled with CFR 0.152.
 */
package com.guoyukun.leman.config.guo;

import com.guoyukun.leman.config.AbstractLemanBeanDefinitionParser;
import com.guoyukun.leman.config.guo.ForTagAdapter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LemanGuoForBeanDefinitionParser
extends AbstractLemanBeanDefinitionParser {
    private static final Logger LOG = LoggerFactory.getLogger(LemanGuoForBeanDefinitionParser.class);

    @Override
    public String getDefaultId() {
        return "leman-guo-for";
    }

    protected Class<?> getBeanClass(Element element) {
        return ForTagAdapter.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.addValue(builder, element, "var", true);
        this.addValue(builder, element, "from", true);
        this.addValue(builder, element, "to", true);
        this.addValue(builder, element, "desc", true);
        NodeList nodeList = element.getChildNodes();
        String var = element.getAttribute("var");
        String fromVal = element.getAttribute("from");
        String toVal = element.getAttribute("to");
        int from = Integer.valueOf(fromVal);
        int to = Integer.valueOf(toVal);
        ArrayList<String> beanNames = new ArrayList<String>();
        for (int index = from; index < to; ++index) {
            int length = nodeList.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nodeList.item(i);
                if (1 != node.getNodeType()) continue;
                Element beanElement = (Element)this.deepReplaceAttr(node, index);
                BeanDefinitionHolder bdh = parserContext.getDelegate().parseBeanDefinitionElement(beanElement);
                this.registerBeanDefinition(bdh, parserContext.getRegistry());
                beanNames.add(bdh.getBeanName());
            }
        }
        this.addValue(builder, "beanNames", beanNames);
        LOG.info("doParse...,{}", (Object)element);
    }

    private Node replaceAllAttr(Node node, int index) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            int attrLen = attrs.getLength();
            for (int j = 0; j < attrLen; ++j) {
                Attr attr = (Attr)attrs.item(j);
                String attrVal = attr.getValue();
                if (!attrVal.contains("{{index}}")) continue;
                String newVal = attrVal.replace("{{index}}", "" + index);
                LOG.info("{} --> {}", (Object)attrVal, (Object)newVal);
                attr.setValue(newVal);
            }
        }
        NodeList childList = node.getChildNodes();
        int childLen = childList.getLength();
        for (int i = 0; i < childLen; ++i) {
            Node child = childList.item(i);
            this.replaceAllAttr(child, index);
        }
        return node;
    }

    private Node deepReplaceAttr(Node node, int index) {
        if (1 != node.getNodeType()) {
            return node;
        }
        Element beanElement = (Element)this.replaceAllAttr(node.cloneNode(true), index);
        LOG.info("\n@@ {}\n {}", (Object)beanElement.getNodeName(), (Object)this.getNodeString(beanElement));
        return beanElement;
    }

    String getNodeString(Node node) {
        try {
            StringWriter writer = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            String output = writer.toString();
            return output.substring(output.indexOf("?>") + 2);
        }
        catch (TransformerException e) {
            LOG.error("", (Throwable)e);
            return node.getTextContent();
        }
    }
}

