/*
 * Decompiled with CFR 0.152.
 */
package cn.gudqs.system.interceptor;

import cn.gudqs.exception.CustomException;
import cn.gudqs.exception.ErrorCodes;
import cn.gudqs.util.CommonUtil;
import cn.gudqs.util.JsonResultUtil;
import cn.gudqs.util.JsonUtils;
import cn.gudqs.util.JwtUtil;
import com.auth0.jwt.interfaces.Claim;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class ApiTokenInterceptor
implements HandlerInterceptor {
    @Value(value="${project.env}")
    private String env;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object arg2) throws Exception {
        boolean flag = true;
        String token = request.getHeader("Authorization");
        String userIdField = "uid";
        try {
            Map<String, Claim> claimMap = JwtUtil.verify(token);
            String tokenType = "type";
            if (claimMap != null && claimMap.containsKey(tokenType)) {
                boolean rightType;
                String type = claimMap.get(tokenType).asString();
                boolean bl = rightType = !"0".equals(type) && !"2".equals(type);
                if (rightType) {
                    throw new CustomException(ErrorCodes.TOKEN_NOT_MATCH);
                }
                if (claimMap.containsKey(userIdField)) {
                    String userId = claimMap.get(userIdField).asString();
                    CommonUtil.setUserId((String)userId, (HttpServletRequest)request);
                }
            }
        }
        catch (Exception e) {
            ErrorCodes errorCodes = ErrorCodes.TOKEN_ERROR;
            if (e instanceof CustomException && ((CustomException)e).getStatusCode().intValue() == ErrorCodes.TOKEN_NOT_MATCH.getCode()) {
                errorCodes = ErrorCodes.TOKEN_NOT_MATCH;
            }
            if (!CommonUtil.isDev((String)this.env)) {
                flag = false;
                response.setContentType("application/json;charset=UTF-8");
                response.getWriter().print(JsonUtils.getJsonString((Object)JsonResultUtil.errorResult((ErrorCodes)errorCodes)));
            }
            request.setAttribute(userIdField, (Object)1);
        }
        return flag;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
    }
}

