/*
 * Decompiled with CFR 0.152.
 */
package cn.gudqs.system.interceptor;

import cn.gudqs.exception.CustomException;
import cn.gudqs.exception.ErrorCodes;
import cn.gudqs.system.admin.service.ISysAuthService;
import cn.gudqs.util.CommonUtil;
import cn.gudqs.util.JsonResultUtil;
import cn.gudqs.util.JsonUtils;
import cn.gudqs.util.JwtUtil;
import com.auth0.jwt.interfaces.Claim;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AdminInterceptor
implements HandlerInterceptor {
    @Value(value="${project.env}")
    private String env;
    private static final List<String> NO_AUTH_URLS = new ArrayList<String>();
    @Resource
    private ISysAuthService sysAuthService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object arg2) throws Exception {
        boolean flag;
        block10: {
            flag = true;
            String token = request.getHeader("Authorization");
            String userIdKey = "uid";
            try {
                Map<String, Claim> claimMap = JwtUtil.verify(token);
                String tokenType = "type";
                if (claimMap.containsKey(tokenType)) {
                    boolean rightType;
                    String type = claimMap.get(tokenType).asString();
                    boolean bl = rightType = "1".equals(type) || "2".equals(type);
                    if (rightType) {
                        if (claimMap.containsKey(userIdKey)) {
                            boolean hasPermission;
                            String userId = claimMap.get(userIdKey).asString();
                            int uid = Integer.parseInt(userId);
                            CommonUtil.setUserId((String)userId, (HttpServletRequest)request);
                            String url = request.getRequestURI();
                            if (!NO_AUTH_URLS.contains(url) && !(hasPermission = this.sysAuthService.hasPermission(uid, url))) {
                                throw new CustomException(ErrorCodes.NO_PERMISSION);
                            }
                        }
                        break block10;
                    }
                    throw new CustomException(ErrorCodes.TOKEN_NOT_MATCH);
                }
                throw new CustomException(ErrorCodes.TOKEN_ERROR);
            }
            catch (Exception e) {
                ErrorCodes errorCodes = ErrorCodes.TOKEN_ERROR;
                if (e instanceof CustomException) {
                    CustomException customException = (CustomException)e;
                    if (customException.getStatusCode().intValue() == ErrorCodes.TOKEN_NOT_MATCH.getCode()) {
                        errorCodes = ErrorCodes.TOKEN_NOT_MATCH;
                    }
                    if (customException.getStatusCode().intValue() == ErrorCodes.NO_PERMISSION.getCode()) {
                        errorCodes = ErrorCodes.NO_PERMISSION;
                    }
                }
                if (!CommonUtil.isDev((String)this.env)) {
                    response.setContentType("application/json;charset=UTF-8");
                    response.getWriter().print(JsonUtils.getJsonString((Object)JsonResultUtil.errorResult((ErrorCodes)errorCodes)));
                    flag = false;
                }
                CommonUtil.setUserId((String)"1", (HttpServletRequest)request);
            }
        }
        return flag;
    }

    static {
        NO_AUTH_URLS.add("/admin/menu/findAll");
        NO_AUTH_URLS.add("/admin/auth/findAll");
    }
}

