/*
 * Decompiled with CFR 0.152.
 */
package cn.gudqs.system.exception;

import cn.gudqs.base.ResultBean;
import cn.gudqs.exception.CustomException;
import cn.gudqs.exception.ErrorCodes;
import cn.gudqs.util.CommonUtil;
import cn.gudqs.util.JsonResultUtil;
import cn.gudqs.util.LoggerUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.http.fileupload.FileUploadBase;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@RestControllerAdvice
public class GlobalExceptionResolver {
    @Value(value="${project.env}")
    private String env;

    public static String getTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    public ResultBean resolveBindException(BindException exception, HttpServletRequest request) {
        LoggerUtil.onlyFile((String)"----------resolveBindException----------");
        String reqInfo = this.getReqInfo(request);
        LoggerUtil.onlyFile((String)reqInfo);
        return this.getResultByValidErrors((BindingResult)exception);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ResultBean resolveValidException(MethodArgumentNotValidException exception, HttpServletRequest request) {
        LoggerUtil.onlyFile((String)"----------resolveValidException----------");
        String reqInfo = this.getReqInfo(request);
        LoggerUtil.onlyFile((String)reqInfo);
        BindingResult bindingResult = exception.getBindingResult();
        return this.getResultByValidErrors(bindingResult);
    }

    private ResultBean getResultByValidErrors(BindingResult bindingResult) {
        List allErrors = bindingResult.getAllErrors();
        if (allErrors == null) {
            return JsonResultUtil.errorResult((String)"all errors null");
        }
        if (allErrors.size() == 1) {
            ObjectError error = (ObjectError)allErrors.get(0);
            String defaultMessage = error.getDefaultMessage();
            return JsonResultUtil.errorResult((String)defaultMessage);
        }
        StringBuilder errSbf = new StringBuilder();
        for (ObjectError error : allErrors) {
            errSbf.append(error.getDefaultMessage()).append(",");
        }
        return JsonResultUtil.errorResult((String)errSbf.substring(0, errSbf.length() - 1));
    }

    private String getReqInfo(HttpServletRequest request) {
        StringBuilder reqInfo = new StringBuilder("\u8bf7\u6c42\u4fe1\u606f: \nIP : ").append(CommonUtil.getRealIp((HttpServletRequest)request)).append(" \nURI: ").append(request.getRequestURI()).append("\n");
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getParameter(name);
            reqInfo.append("   \u8bf7\u6c42\u53c2\u6570\uff1a").append(name).append(":").append(value).append("\n");
        }
        return reqInfo.toString() + "\n";
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResultBean resolveException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) {
        CustomException customException;
        String reqInfo = this.getReqInfo(httpServletRequest);
        LoggerUtil.onlyFile((String)reqInfo);
        e.printStackTrace();
        int code = ErrorCodes.ERROR.getCode();
        if (e instanceof CustomException) {
            customException = (CustomException)e;
            code = customException.getStatusCode();
        } else {
            boolean dev = CommonUtil.isDev((String)this.env);
            String msg = "\u7cfb\u7edf\u5f00\u5c0f\u5dee\u4e86";
            if (dev) {
                Throwable cause = e.getCause();
                msg = e.getMessage();
                if (cause != null) {
                    msg = msg + " :: " + cause;
                }
            }
            if (httpServletRequest.getHeader("back-error-trace") != null) {
                msg = GlobalExceptionResolver.getTrace(e);
            }
            if (httpServletRequest.getHeader("back-req-info") != null) {
                msg = msg + reqInfo;
            }
            customException = new CustomException(msg);
        }
        return JsonResultUtil.errorResult((String)customException.getMessage(), (Integer)code);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    @ResponseBody
    public ResultBean resolveFileSizeLimitException(HttpServletRequest request, MaxUploadSizeExceededException e) {
        String reqInfo = this.getReqInfo(request);
        LoggerUtil.onlyFile((String)reqInfo);
        Throwable cause = e.getRootCause();
        if (cause instanceof FileUploadBase.FileSizeLimitExceededException) {
            FileUploadBase.FileSizeLimitExceededException exception = (FileUploadBase.FileSizeLimitExceededException)cause;
            long permittedSize = exception.getPermittedSize();
            double cast = 1048576.0;
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            String message = String.format("\u6587\u4ef6 [%s] \u8fc7\u5927, \u4e0d\u5f97\u8d85\u8fc7 %sM", exception.getFileName(), decimalFormat.format((double)permittedSize / cast));
            LoggerUtil.info((String)message, GlobalExceptionResolver.class);
            return JsonResultUtil.errorResult((String)message);
        }
        return JsonResultUtil.errorResult((String)e.getMessage());
    }
}

