/*
 * Decompiled with CFR 0.152.
 */
package cn.gudqs.helper;

import cn.gudqs.business.common.entity.SysDictionaryModel;
import cn.gudqs.business.common.service.ISysDictionaryService;
import cn.gudqs.helper.MapCache;
import cn.gudqs.helper.SpringContextUtil;
import java.util.List;

public class DictionaryUtil<K, V>
extends MapCache<K, V> {
    private static DictionaryUtil<String, SysDictionaryModel> instance;
    private static DictionaryUtil<String, List<SysDictionaryModel>> parentCodeInstance;
    private ISysDictionaryService sysDictionaryService = (ISysDictionaryService)SpringContextUtil.getBean(ISysDictionaryService.class);
    private Integer type;

    private DictionaryUtil(Integer type) {
        this();
        this.type = type;
    }

    private DictionaryUtil() {
    }

    public static DictionaryUtil<String, SysDictionaryModel> getInstance() {
        if (instance == null) {
            instance = new DictionaryUtil(0);
        }
        return instance;
    }

    public static DictionaryUtil<String, List<SysDictionaryModel>> getParentInstance() {
        if (parentCodeInstance == null) {
            parentCodeInstance = new DictionaryUtil(1);
        }
        return parentCodeInstance;
    }

    public static String findValByCode(String code) {
        return DictionaryUtil.findValByCode(code, code);
    }

    public static String findValByCode(String code, String defaultVal) {
        SysDictionaryModel byCode = DictionaryUtil.findByCode(code);
        if (byCode != null) {
            return byCode.getDictionaryValue();
        }
        return defaultVal;
    }

    public static SysDictionaryModel findByCode(String code) {
        return (SysDictionaryModel)DictionaryUtil.getInstance().get(code);
    }

    public static List<SysDictionaryModel> findByParentCode(String parentCode) {
        return (List)DictionaryUtil.getParentInstance().get(parentCode);
    }

    public static void setFromParent(List<SysDictionaryModel> dictionaryModels) {
        for (SysDictionaryModel dictionaryModel : dictionaryModels) {
            DictionaryUtil.getInstance().set(dictionaryModel.getDictionaryCode(), dictionaryModel);
        }
    }

    public static void set(SysDictionaryModel dictionaryModel) {
        if (dictionaryModel != null) {
            DictionaryUtil.getInstance().set(dictionaryModel.getDictionaryCode(), dictionaryModel);
        }
    }

    public V loadDataFromDb(K key) {
        if (key instanceof String) {
            String key0 = (String)key;
            if (this.type == 1) {
                return (V)this.loadDicListByParent(key0);
            }
            if (this.type == 0) {
                return (V)this.loadDicData(key0);
            }
        }
        return (V)super.loadDataFromDb(key);
    }

    private List<SysDictionaryModel> loadDicListByParent(String parentCode) {
        List<SysDictionaryModel> sysDictionaryModels = this.sysDictionaryService.findByParentCode(parentCode);
        if (sysDictionaryModels.size() > 0) {
            DictionaryUtil.setFromParent(sysDictionaryModels);
            return sysDictionaryModels;
        }
        return null;
    }

    private SysDictionaryModel loadDicData(String code) {
        return (SysDictionaryModel)this.sysDictionaryService.selectOne(new SysDictionaryModel(code));
    }
}

